/*
 * Decompiled with CFR 0.152.
 */
package circPrimer;

import circPrimer.MainFrame;
import circPrimer.function;
import com.itextpdf.awt.PdfGraphics2D;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfWriter;
import java.awt.AWTException;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.HeadlessException;
import java.awt.RenderingHints;
import java.awt.Robot;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.geom.AffineTransform;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.text.BoxView;
import javax.swing.text.ComponentView;
import javax.swing.text.Element;
import javax.swing.text.GlyphView;
import javax.swing.text.IconView;
import javax.swing.text.LabelView;
import javax.swing.text.ParagraphView;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public class fmPic
extends JFrame {
    private static final long serialVersionUID = 1L;
    private JPanel contentPane;
    private String circStructure = null;
    private String circFuntion = null;
    private String circPrimerInf = null;
    private String circSymbol = null;
    private String circ_m6a_str = null;
    private String topLeftInf = null;
    private String Parent_CDS_in_circ = null;
    private DefaultTableModel BestTranscriptModel = null;
    private String bottomLeftInf = null;
    private static JTabbedPane tabbedPane;
    private String seq = null;
    private int cbxMindex = 0;
    private int circLen = 0;
    private String chrNo = null;
    private boolean firstpaint = false;
    private String strand = null;
    private String Model = null;
    private List<String> features;
    private String pdfPath = null;
    static final int HEIGHT = 620;
    static int WIDTH;
    private JTable JTbORFs;
    private JTable JTbm6as;
    static final int M6AUPSEQLEN = 20;
    JPanel panelLeft;
    private JTextArea textArea2;
    JComboBox cbxMimORFLen;
    JComboBox cbxM6a;
    JScrollPane scrollPane1top;
    JScrollPane scrollPane2top;
    JScrollPane scrollPane2bottom;
    JScrollPane scrollPane1;
    JScrollPane scrollPane2;
    JTextPane textPane;
    JComboBox cbxM;
    JComboBox cbxORFs;
    JProgressBar pgbORF;
    Color[] colors = new Color[]{new Color(138, 43, 26), Color.orange, Color.YELLOW, Color.RED, Color.BLUE, Color.green, Color.CYAN, new Color(107, 142, 35), new Color(255, 182, 193), new Color(255, 0, 255), new Color(119, 136, 153), new Color(175, 238, 238), Color.WHITE};

    static {
        WIDTH = 600;
    }

    public void drawString(Graphics2D g2, int angle, int centerX, int centerY, int r, String txt, Color color) {
        g2.setColor(color);
        int ang = angle;
        if (angle > 180) {
            ang = angle - 180;
        }
        Font font = new Font("Arial", 0, 18);
        FontMetrics fm = g2.getFontMetrics(font);
        int width = fm.stringWidth(txt);
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.rotate(Math.toRadians(ang - 90), 0.0, 0.0);
        Font rotatedFont = font.deriveFont(affineTransform);
        g2.setFont(rotatedFont);
        double a = Math.toRadians(ang);
        int txtX = 0;
        int txtY = 0;
        if (angle > 180) {
            txtX = centerX - (int)Math.round((double)r * Math.sin(a));
            txtY = centerY + (int)Math.round((double)r * Math.cos(a));
        } else {
            txtX = centerX + (int)Math.round((double)(r -= width) * Math.sin(a));
            txtY = centerY - (int)Math.round((double)r * Math.cos(a));
        }
        g2.drawString(txt, txtX, txtY);
    }

    public void drawString(Graphics2D g2, Font font, int angle, int centerX, int centerY, int r, String txt, Color color) {
        g2.setColor(color);
        int ang = angle;
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.rotate(Math.toRadians(ang), 0.0, 0.0);
        Font rotatedFont = font.deriveFont(affineTransform);
        g2.setFont(rotatedFont);
        double a = Math.toRadians(ang);
        int txtX = 0;
        int txtY = 0;
        txtX = centerX + (int)Math.round((double)r * Math.sin(a));
        txtY = centerY - (int)Math.round((double)r * Math.cos(a));
        g2.drawString(txt, txtX, txtY);
    }

    public Color getFunctionColor(String UtrEtalname) {
        if (UtrEtalname.equals("start_codon")) {
            return Color.PINK;
        }
        if (UtrEtalname.equals("CDS")) {
            return Color.GREEN;
        }
        if (UtrEtalname.equals("stop_codon")) {
            return Color.RED;
        }
        if (UtrEtalname.equals("UTR")) {
            return Color.BLACK;
        }
        if (UtrEtalname.equals("five_prime_utr")) {
            return Color.blue;
        }
        if (UtrEtalname.equals("three_prime_utr")) {
            return Color.BLACK;
        }
        return Color.BLACK;
    }

    public Color getm6aColor(String m6a) {
        if (m6a.equals("m6A")) {
            return Color.RED;
        }
        if (m6a.equals("m7G")) {
            return new Color(0, 100, 0);
        }
        if (m6a.equals("m1A")) {
            return new Color(148, 0, 211);
        }
        if (m6a.equals("m5C")) {
            return Color.blue;
        }
        if (m6a.equals("Nm")) {
            return new Color(128, 128, 2);
        }
        if (m6a.equals("Psi")) {
            return new Color(132, 0, 0);
        }
        return Color.BLACK;
    }

    public void drawFunction(Graphics2D g2, String FunctionStr, int centerX, int centerY, int R) {
        if (FunctionStr == null | FunctionStr.length() == 0) {
            return;
        }
        String s2 = FunctionStr;
        String[] circFunction = s2.split(";");
        int circlength = Integer.valueOf(circFunction[0]);
        Font font = new Font("Arial", 0, 14);
        FontMetrics fm = g2.getFontMetrics(font);
        g2.setFont(font);
        int width = fm.stringWidth("C");
        int Height = fm.getHeight();
        String fstr = "#";
        int findex = 0;
        int i = 1;
        while (i < circFunction.length) {
            String[] s = circFunction[i].split(" ");
            String lbl = s[0];
            g2.setColor(this.getFunctionColor(lbl));
            int lineR = R - 4;
            if (lbl.equals("start_codon") | lbl.equals("stop_codon")) {
                lineR = R - 8;
            }
            int start = Integer.valueOf(s[1]);
            int end = Integer.valueOf(s[2]);
            int angle = Math.round(360 * (end - start + 1) / circlength);
            int angleStart = Math.round(360 * start / circlength);
            BasicStroke stroke = new BasicStroke(3.0f);
            g2.setStroke(stroke);
            g2.drawArc(centerX - lineR, centerY - lineR, lineR * 2, lineR * 2, 90 - (angleStart + angle), angle);
            int b = fstr.indexOf("#" + lbl + "#");
            if (b == -1) {
                int lx = centerX + 150;
                g2.drawLine(lx, 7 + findex * Height, lx + width, 7 + findex * Height);
                g2.setColor(Color.BLACK);
                g2.drawString(lbl, lx + width * 2, 5 + (findex + 1) * Height - Height / 2);
                fstr = String.valueOf(fstr) + lbl + "#";
                ++findex;
            }
            ++i;
        }
    }

    public void drawArc2(Graphics2D g2, int centerX, int centerY, int R, int angleStart, int angle) {
        int x = centerX - R;
        int y = centerY - R;
        int startAngle = angleStart;
        int depth = -3;
        int count = angle / 180 + 1;
        if (angle % 180 == 0) {
            count = angle / 180;
        }
        int subangle = 180;
        double ang = Math.toRadians(angleStart);
        int i = 0;
        while (i < count) {
            if (angle % 180 > 0 & i == count - 1) {
                subangle = angle % 180;
            }
            int w = 2 * R + 2 * depth * i;
            if (i % 2 == 0) {
                if (i != 0) {
                    x = (int)((double)(x - depth) - (double)depth * Math.cos(ang));
                    y = (int)((double)y - ((double)depth - (double)depth * Math.sin(ang)));
                }
                g2.drawArc(x, y, w, w, startAngle + i * 180, subangle);
            } else {
                x = (int)((double)x - (double)depth * (1.0 - Math.cos(ang)));
                y = (int)((double)(y - depth) - (double)depth * Math.sin(ang));
                g2.drawArc(x, y, w, w, i * 180 + startAngle, subangle);
            }
            ++i;
        }
    }

    public void drawORFs(Graphics2D g2, int centerX, int centerY, int R) {
        if (tabbedPane.getSelectedIndex() == 1 & this.cbxORFs.getSelectedIndex() == 0) {
            return;
        }
        if (tabbedPane.getSelectedIndex() == 1 & this.cbxORFs.getSelectedIndex() >= 0 & this.cbxORFs.getSelectedIndex() - 1 < this.JTbORFs.getRowCount()) {
            this.JTbORFs.setRowSelectionInterval(this.cbxORFs.getSelectedIndex() - 1, this.cbxORFs.getSelectedIndex() - 1);
        }
        if (this.JTbORFs.getRowCount() == 0 | this.JTbORFs.getModel() == null) {
            return;
        }
        int circlength = this.seq.length();
        int[] rows = this.JTbORFs.getSelectedRows();
        if (rows.length == 0) {
            rows = new int[this.JTbORFs.getRowCount()];
            int i = 0;
            while (i < this.JTbORFs.getRowCount()) {
                rows[i] = i;
                ++i;
            }
        }
        int index = 0;
        int indexLbel = 0;
        int[] nArray = rows;
        int n = rows.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            int c = index % 10;
            if (c == 2) {
                c = 10;
            }
            g2.setColor(this.colors[c]);
            int start = Integer.valueOf(MainFrame.getValueAt(this.JTbORFs, i, "Start")) - 1;
            int end = Integer.valueOf(MainFrame.getValueAt(this.JTbORFs, i, "Stop")) - 1;
            String lbl = MainFrame.getValueAt(this.JTbORFs, i, "Label");
            if (end < start) {
                end += circlength;
            }
            int lineR = R - 6 * (index + 1);
            String ORF_SEQ = MainFrame.getValueAt(this.JTbORFs, i, "ORF_SEQ");
            int angle = Math.round(360 * ORF_SEQ.length() / circlength);
            int angleStart = Math.round(360 * start / circlength);
            BasicStroke stroke = new BasicStroke(3.0f);
            g2.setStroke(stroke);
            if (angle >= 360) {
                this.drawArc2(g2, centerX, centerY, lineR, 90 - (angleStart + angle), angle);
                index += angle / 360;
            } else {
                g2.drawArc(centerX - lineR, centerY - lineR, lineR * 2, lineR * 2, 90 - (angleStart + angle), angle);
            }
            if (rows.length == 1 & tabbedPane.getSelectedIndex() == 0) {
                String if_CDS_overlap;
                int bufindex = 2;
                int labindex = 1;
                String IRES = MainFrame.getValueAt(this.JTbORFs, i, "IRES");
                if (!IRES.equals("None")) {
                    String[] s1 = IRES.split("-");
                    end = Integer.valueOf(s1[1]);
                    if (end < (start = Integer.valueOf(s1[0]).intValue())) {
                        end += circlength;
                    }
                    lineR = R - 6 * (index + bufindex);
                    angle = Math.round(360 * (end - start + 1) / circlength);
                    angleStart = Math.round(360 * start / circlength);
                    g2.setColor(Color.BLUE);
                    g2.drawArc(centerX - lineR, centerY - lineR, lineR * 2, lineR * 2, 90 - (angleStart + angle), angle);
                    Font font = new Font("Arial", 0, 14);
                    FontMetrics fm = g2.getFontMetrics(font);
                    g2.setFont(font);
                    int width = fm.stringWidth("C");
                    int Height = fm.getHeight();
                    int lx = centerX + 220;
                    g2.drawLine(lx, 7 + (indexLbel + 1 + labindex - 1) * Height, lx + width, 7 + (indexLbel + 1 + labindex - 1) * Height);
                    g2.setColor(Color.BLACK);
                    g2.drawString("IRES", lx + width * 2, 5 + (indexLbel + 2 + labindex - 1) * Height - Height / 2);
                    ++bufindex;
                    ++labindex;
                }
                if ((if_CDS_overlap = MainFrame.getValueAt(this.JTbORFs, i, "if_CDS_overlap")).equals("1")) {
                    String cdsStr = MainFrame.getValueAt(this.JTbORFs, i, "cdsStr");
                    String[] cdsStrs = cdsStr.split(",");
                    if (cdsStrs.length == 2 & bufindex == 3) {
                        ++bufindex;
                    }
                    int j = 0;
                    while (j < cdsStrs.length) {
                        String[] s1 = cdsStrs[j].split(" ");
                        end = Integer.valueOf(s1[1]);
                        start = Integer.valueOf(s1[0]);
                        lineR = R - 6 * (index + bufindex - j);
                        angle = Math.round(360 * (end - start + 1) / circlength);
                        angleStart = Math.round(360 * start / circlength);
                        g2.setColor(Color.RED);
                        g2.drawArc(centerX - lineR, centerY - lineR, lineR * 2, lineR * 2, 90 - (angleStart + angle), angle);
                        ++j;
                    }
                    Font font = new Font("Arial", 0, 14);
                    FontMetrics fm = g2.getFontMetrics(font);
                    g2.setFont(font);
                    int width = fm.stringWidth("C");
                    int Height = fm.getHeight();
                    int lx = centerX + 220;
                    g2.drawLine(lx, 7 + (indexLbel + 1 + labindex - 1) * Height, lx + width, 7 + (indexLbel + 1 + labindex - 1) * Height);
                    g2.setColor(Color.BLACK);
                    g2.drawString("CDS", lx + width * 2, 5 + (indexLbel + 2 + labindex - 1) * Height - Height / 2);
                }
            }
            g2.setColor(this.colors[c]);
            Font font = new Font("Arial", 0, 14);
            FontMetrics fm = g2.getFontMetrics(font);
            g2.setFont(font);
            int width = fm.stringWidth("C");
            int Height = fm.getHeight();
            int lx = centerX + 220;
            g2.drawLine(lx, 7 + indexLbel * Height, lx + width, 7 + indexLbel * Height);
            g2.setColor(Color.BLACK);
            g2.drawString(lbl, lx + width * 2, 5 + (indexLbel + 1) * Height - Height / 2);
            ++index;
            ++indexLbel;
            ++n2;
        }
    }

    public void drawcircm6a_all(Graphics2D g2, int centerX, int centerY, int R) {
        if (this.cbxM6a.getSelectedIndex() == 0) {
            this.drawcircm6a(g2, this.circ_m6a_str, centerX, centerY, R);
        } else if (this.cbxM6a.getSelectedIndex() >= 0) {
            this.drawcircm6a(g2, centerX, centerY, R);
        }
    }

    public void drawcircm6a(Graphics2D g2, String circm6aStr, int centerX, int centerY, int R) {
        int i;
        if (circm6aStr == null | tabbedPane.getSelectedIndex() != 1) {
            return;
        }
        if (circm6aStr.length() == 0) {
            return;
        }
        if (this.circ_m6a_str.indexOf(";;") > 0) {
            return;
        }
        String s2 = circm6aStr;
        String[] m6a = s2.split(";");
        if (this.cbxORFs.getSelectedIndex() != 0) {
            R -= 10;
        }
        int circlength = Integer.valueOf(m6a[0]);
        Font font = new Font("Arial", 0, 14);
        FontMetrics fm = g2.getFontMetrics(font);
        g2.setFont(font);
        int width = fm.stringWidth("C");
        int Height = fm.getHeight();
        String fstr = "#";
        int findex = 0;
        String[] m6a2 = m6a[1].split(",");
        int[] rows = this.JTbm6as.getSelectedRows();
        if (rows.length == 0) {
            rows = new int[this.JTbm6as.getRowCount()];
            i = 0;
            while (i < this.JTbm6as.getRowCount()) {
                rows[i] = i;
                ++i;
            }
        }
        i = 0;
        while (i < m6a2.length) {
            int[] nArray = rows;
            int n = rows.length;
            int n2 = 0;
            while (n2 < n) {
                int j = nArray[n2];
                if (i == j) {
                    String[] s = m6a2[i].split(" ");
                    String lbl = s[0];
                    g2.setColor(this.getm6aColor(lbl));
                    int lineR = R - 4;
                    int start = Integer.valueOf(s[1]);
                    int end = Integer.valueOf(s[2]);
                    int angle = Math.round(360 * (end - start + 1) / circlength);
                    int angleStart = Math.round(360 * start / circlength);
                    BasicStroke stroke = new BasicStroke(5.0f);
                    g2.setStroke(stroke);
                    g2.drawArc(centerX - lineR, centerY - lineR, lineR * 2, lineR * 2, 90 - (angleStart + angle), angle);
                    int b = fstr.indexOf("#" + lbl + "#");
                    if (b == -1) {
                        int lx = centerX + 150;
                        g2.drawLine(lx, 7 + findex * Height, lx + width, 7 + findex * Height);
                        g2.setColor(Color.BLACK);
                        g2.drawString(lbl, lx + width * 2, 5 + (findex + 1) * Height - Height / 2);
                        fstr = String.valueOf(fstr) + lbl + "#";
                        ++findex;
                    }
                }
                ++n2;
            }
            ++i;
        }
    }

    public void drawcircm6a(Graphics2D g2, int centerX, int centerY, int R) {
        int i;
        if (this.cbxM6a.getSelectedIndex() <= 0 | tabbedPane.getSelectedIndex() != 1) {
            return;
        }
        if (this.cbxORFs.getSelectedIndex() != 0) {
            R -= 10;
        }
        int circlen = this.circLen;
        Font font = new Font("Arial", 0, 14);
        FontMetrics fm = g2.getFontMetrics(font);
        g2.setFont(font);
        int width = fm.stringWidth("C");
        int Height = fm.getHeight();
        String fstr = "#";
        int findex = 0;
        int[] rows = this.JTbm6as.getSelectedRows();
        if (rows.length == 0) {
            rows = new int[this.JTbm6as.getRowCount()];
            i = 0;
            while (i < this.JTbm6as.getRowCount()) {
                rows[i] = i;
                ++i;
            }
        }
        int[] nArray = rows;
        int n = rows.length;
        int n2 = 0;
        while (n2 < n) {
            i = nArray[n2];
            int position = Integer.valueOf(MainFrame.getValueAt(this.JTbm6as, i, "Position"));
            String lbl = MainFrame.getValueAt(this.JTbm6as, i, "Type");
            g2.setColor(this.getm6aColor(lbl));
            int lineR = R - 4;
            int start = position - Math.round(circlen / 360);
            int end = position + Math.round(circlen / 360);
            int angle = Math.round(360 * (end - start + 1) / circlen);
            int angleStart = Math.round(360 * start / circlen);
            BasicStroke stroke = new BasicStroke(5.0f);
            g2.setStroke(stroke);
            g2.drawArc(centerX - lineR, centerY - lineR, lineR * 2, lineR * 2, 90 - (angleStart + angle), angle);
            int b = fstr.indexOf("#" + lbl + "#");
            if (b == -1) {
                int lx = centerX + 150;
                g2.drawLine(lx, 7 + findex * Height, lx + width, 7 + findex * Height);
                g2.setColor(Color.BLACK);
                g2.drawString(lbl, lx + width * 2, 5 + (findex + 1) * Height - Height / 2);
                fstr = String.valueOf(fstr) + lbl + "#";
                ++findex;
            }
            ++n2;
        }
    }

    public void drawPrimer(Graphics2D g2, String PrimerStr, int centerX, int centerY, int R) {
        String s2 = PrimerStr;
        String[] primerFR = s2.split(";");
        int circlength = Integer.valueOf(primerFR[0]);
        Font font = new Font("Arial", 0, 18);
        FontMetrics fm = g2.getFontMetrics(font);
        int fontWidth = fm.stringWidth("F");
        int fontHeight = fm.getHeight();
        int outR = R;
        int primerR = outR + fontHeight / 2 + 1;
        int primerTxtR = outR + fontHeight / 4;
        int i = 1;
        while (i < primerFR.length) {
            String[] s = primerFR[i].split(" ");
            String lbl = s[0];
            int start = Integer.valueOf(s[1]);
            int end = Integer.valueOf(s[2]);
            int angle = Math.round(360 * (end - start + 1) / circlength);
            int angleStart = Math.round(360 * start / circlength);
            float x = (float)((double)(360 * fontWidth) / (6.2831852 * (double)primerR));
            int lblAngle = Math.round(x);
            if (lbl.equals("F")) {
                this.drawString(g2, font, angleStart - lblAngle - 1, centerX, centerY, primerTxtR, lbl, Color.RED);
                this.drawString(g2, font, angleStart + angle - lblAngle + 1, centerX, centerY, primerTxtR, ">", Color.RED);
            } else {
                this.drawString(g2, font, angleStart + angle + 1, centerX, centerY, primerTxtR, lbl, Color.BLUE);
                this.drawString(g2, font, angleStart - 1, centerX, centerY, primerTxtR, "<", Color.BLUE);
            }
            BasicStroke stroke = new BasicStroke(3.0f);
            g2.setStroke(stroke);
            g2.drawArc(centerX - primerR, centerY - primerR, primerR * 2, primerR * 2, 90 - (angleStart + angle), angle);
            ++i;
        }
    }

    public void drawTopLeft(Graphics2D g2, Color color, String inf) {
        if (inf == null) {
            return;
        }
        g2.setColor(color);
        Font font = new Font("Arial", 0, 14);
        g2.setFont(font);
        String[] s = inf.split("\n");
        int i = 0;
        while (i < s.length) {
            g2.drawString(s[i], 10, (i + 1) * 15);
            ++i;
        }
    }

    public void initm6a() {
        Thread thread = new Thread(){

            @Override
            public void run() {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        if ((this).fmPic.this.cbxM6a.getSelectedIndex() == 0) {
                            DefaultTableModel model = function.getM6a(fmPic.this.circ_m6a_str, fmPic.this.seq, fmPic.this.chrNo, fmPic.this.strand, 20);
                            fmPic.this.JTbm6as.setModel(model);
                            TableColumnModel columnModel = fmPic.this.JTbm6as.getColumnModel();
                            TableColumn tableColumn = columnModel.getColumn(3);
                            tableColumn.setMaxWidth(0);
                            tableColumn.setMinWidth(0);
                            tableColumn.setPreferredWidth(0);
                            int i = 0;
                            while (i < 4) {
                                TableColumn Column1 = fmPic.this.JTbm6as.getColumnModel().getColumn(i);
                                DefaultTableCellRenderer render = new DefaultTableCellRenderer();
                                render.setHorizontalAlignment(0);
                                Column1.setCellRenderer(render);
                                ++i;
                            }
                            TableColumn C1 = fmPic.this.JTbm6as.getColumnModel().getColumn(1);
                            C1.setPreferredWidth(150);
                            (this).fmPic.this.scrollPane2top.setViewportView(fmPic.this.JTbm6as);
                        } else if ((this).fmPic.this.cbxM6a.getSelectedIndex() > 0) {
                            DefaultTableModel model = function.getM6a("", fmPic.this.seq, (this).fmPic.this.cbxM6a.getSelectedItem().toString(), 20);
                            fmPic.this.JTbm6as.setModel(model);
                            TableColumnModel columnModel = fmPic.this.JTbm6as.getColumnModel();
                            TableColumn tableColumn = columnModel.getColumn(3);
                            tableColumn.setMaxWidth(0);
                            tableColumn.setMinWidth(0);
                            tableColumn.setPreferredWidth(0);
                            tableColumn = columnModel.getColumn(4);
                            tableColumn.setMaxWidth(0);
                            tableColumn.setMinWidth(0);
                            tableColumn.setPreferredWidth(0);
                            int i = 0;
                            while (i < 3) {
                                TableColumn Column1 = fmPic.this.JTbm6as.getColumnModel().getColumn(i);
                                DefaultTableCellRenderer render = new DefaultTableCellRenderer();
                                render.setHorizontalAlignment(0);
                                Column1.setCellRenderer(render);
                                ++i;
                            }
                            (this).fmPic.this.scrollPane2top.setViewportView(fmPic.this.JTbm6as);
                        }
                    }
                };
                SwingUtilities.invokeLater(runnable);
            }
        };
        thread.start();
    }

    public void initORF(final int mimiOrfLen) {
        new Thread(){

            @Override
            public void run() {
                fmPic.this.pgbORF.setVisible(true);
                if (fmPic.this.Model == null) {
                    fmPic.this.Model = function.getTGBoostModel();
                    fmPic.this.features = function.getKmers();
                }
                if (fmPic.this.seq == null) {
                    fmPic.this.pgbORF.setVisible(false);
                    return;
                }
                List<Integer> orf = function.getORF(fmPic.this.seq);
                int[][] rz = function.getORF(orf);
                DefaultTableModel orfmodel = function.getORF(rz, fmPic.this.seq, mimiOrfLen, fmPic.this.Model, fmPic.this.features, fmPic.this.Parent_CDS_in_circ);
                fmPic.this.JTbORFs.setModel(orfmodel);
                TableColumnModel columnModel = fmPic.this.JTbORFs.getColumnModel();
                TableColumn tableColumn = columnModel.getColumn(5);
                tableColumn.setMaxWidth(0);
                tableColumn.setMinWidth(0);
                tableColumn.setPreferredWidth(0);
                tableColumn = columnModel.getColumn(6);
                tableColumn.setMaxWidth(0);
                tableColumn.setMinWidth(0);
                tableColumn.setPreferredWidth(0);
                tableColumn = columnModel.getColumn(7);
                tableColumn.setMaxWidth(0);
                tableColumn.setMinWidth(0);
                tableColumn.setPreferredWidth(0);
                tableColumn = columnModel.getColumn(9);
                tableColumn.setMaxWidth(0);
                tableColumn.setMinWidth(0);
                tableColumn.setPreferredWidth(0);
                tableColumn = columnModel.getColumn(10);
                tableColumn.setMaxWidth(0);
                tableColumn.setMinWidth(0);
                tableColumn.setPreferredWidth(0);
                tableColumn = columnModel.getColumn(11);
                tableColumn.setMaxWidth(0);
                tableColumn.setMinWidth(0);
                tableColumn.setPreferredWidth(0);
                TableColumn C1 = fmPic.this.JTbORFs.getColumnModel().getColumn(8);
                C1.setPreferredWidth(100);
                C1 = fmPic.this.JTbORFs.getColumnModel().getColumn(4);
                C1.setPreferredWidth(90);
                fmPic.makeFace(fmPic.this.JTbORFs, 8);
                fmPic.this.scrollPane1top.setViewportView(fmPic.this.JTbORFs);
                fmPic.this.initcbxORFs();
                fmPic.this.initm6a();
                fmPic.this.initcbxm6a();
                fmPic.this.pgbORF.setVisible(false);
            }
        }.start();
    }

    public void initcbxORFs() {
        this.cbxORFs.removeAllItems();
        this.cbxORFs.addItem("NULL");
        int i = 0;
        while (i < this.JTbORFs.getRowCount()) {
            String buf = MainFrame.getValueAt(this.JTbORFs, i, "Label").trim();
            this.cbxORFs.addItem(buf);
            ++i;
        }
    }

    public void initcbxm6a() {
        this.cbxM6a.removeAllItems();
        this.cbxM6a.addItem("High-confidence");
        DefaultTableModel model = function.getm6aseq();
        JTable tb = new JTable(model);
        int i = 0;
        while (i < model.getRowCount()) {
            String fragment = MainFrame.getValueAt(tb, i, "fragment");
            this.cbxM6a.addItem(fragment);
            ++i;
        }
    }

    public void drawBottomLeft(Graphics2D g2, Color color, String inf, int height) {
        if (inf == null) {
            return;
        }
        g2.setColor(color);
        Font font = new Font("Arial", 0, 14);
        g2.setFont(font);
        String[] s = inf.split("\n");
        int i = s.length - 1;
        while (i >= 0) {
            g2.drawString(s[s.length - 1 - i], 10, height - 50 - i * 15);
            --i;
        }
    }

    public void drawTopRect(Graphics2D g2, int circLength, int centerX, int centerY, int outR) {
        g2.setColor(Color.black);
        int TopRectWidth = 8;
        int TopRectHeight = 20;
        g2.fillRect(centerX - TopRectWidth / 2, centerY - outR - TopRectHeight, TopRectWidth, TopRectHeight);
        Font font = new Font("Arial", 0, 14);
        FontMetrics fm = g2.getFontMetrics(font);
        g2.setFont(font);
        String circlengthStr = String.valueOf(circLength);
        int width = fm.stringWidth(circlengthStr);
        g2.drawString("1", centerX + TopRectWidth / 2, centerY - outR - TopRectHeight);
        g2.drawString(circlengthStr, centerX - TopRectWidth / 2 - width, centerY - outR - TopRectHeight);
    }

    public String formatStr(String s, int len) {
        String rz = "";
        String[] split1 = s.split("\n");
        int i = 0;
        while (i < split1.length) {
            String b = split1[i];
            if (b.length() > len) {
                String r = "";
                while (b.length() > len) {
                    r = String.valueOf(r) + b.substring(0, len) + "\n";
                    b = b.substring(60, b.length());
                }
                rz = String.valueOf(rz) + r + b + '\n';
            } else {
                rz = String.valueOf(rz) + b + '\n';
            }
            ++i;
        }
        return rz;
    }

    public ArrayList<Integer> getAUG(String seq, String str, String flag) {
        ArrayList<Integer> List2 = new ArrayList<Integer>();
        int n = seq.indexOf(flag);
        while (n > -1) {
            int oneStart = seq.indexOf("\n", n + 1) + 1;
            int oneEnd = seq.indexOf("\n\n", n + 1);
            String one = seq.substring(oneStart, oneEnd);
            this.getAUG(one, str, oneStart, List2);
            n = seq.indexOf(flag, n + 1);
        }
        return List2;
    }

    public void getAUG(String seq, String str, int start, ArrayList<Integer> List2) {
        int len = str.length();
        String[] seqs = seq.split("\n");
        int i = 0;
        while (i < seqs.length) {
            int n = seqs[i].indexOf(str);
            while (n > -1) {
                if (n % 3 == 0) {
                    List2.add(start + n);
                    List2.add(len);
                }
                n = seqs[i].indexOf(str, n + 1);
            }
            start = start + seqs[i].length() + 1;
            ++i;
        }
    }

    public ArrayList<Integer> getStop(String seq, String flag) {
        ArrayList<Integer> List2 = new ArrayList<Integer>();
        int n = seq.indexOf(flag);
        while (n > -1) {
            int oneStart = seq.indexOf("\n", n + 1) + 1;
            int oneEnd = seq.indexOf("\n\n", n + 1);
            String one = seq.substring(oneStart, oneEnd);
            this.getStop(one, oneStart, List2);
            n = seq.indexOf(flag, n + 1);
        }
        return List2;
    }

    public void getStop(String seq, int start, ArrayList<Integer> List2) {
        String stop = seq.substring(seq.length() - 3, seq.length());
        if (stop.equals("TAA") || stop.equals("TAG") || stop.equals("TGA")) {
            List2.add(start + seq.length() - 3);
            List2.add(3);
        }
    }

    public ArrayList<Integer> getM(String seq, String str, String flag) {
        ArrayList<Integer> List2 = new ArrayList<Integer>();
        int n = seq.indexOf(flag);
        while (n > -1) {
            int oneStart = seq.indexOf("\n", n + 1) + 1;
            int oneEnd = seq.indexOf("\n\n", n + 1);
            if (oneEnd == -1) {
                oneEnd = seq.length();
            }
            String one = seq.substring(oneStart, oneEnd);
            this.getM(one, str, oneStart, List2);
            n = seq.indexOf(flag, n + 1);
        }
        return List2;
    }

    public void getM(String seq, String str, int start, ArrayList<Integer> List2) {
        int len = str.length();
        String[] seqs = seq.split("\n");
        int i = 0;
        while (i < seqs.length) {
            int n = seqs[i].indexOf(str);
            while (n > -1) {
                List2.add(start + n);
                List2.add(len);
                n = seqs[i].indexOf(str, n + 1);
            }
            start = start + seqs[i].length() + 1;
            ++i;
        }
    }

    public static void makeFace(JTable table, final int columnI) {
        if (table.getRowCount() == 0) {
            return;
        }
        try {
            DefaultTableCellRenderer tcr = new DefaultTableCellRenderer(){
                private static final long serialVersionUID = 1L;

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    String[] pos;
                    this.setForeground(Color.BLACK);
                    this.setHorizontalAlignment(0);
                    String ires = table.getValueAt(row, columnI).toString();
                    String if_CDS_overlap = table.getValueAt(row, 10).toString();
                    if (if_CDS_overlap.equals("1") && column == 0) {
                        this.setForeground(Color.red);
                    }
                    if ((pos = ires.split("-")).length != 2) {
                        return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    }
                    if (Integer.valueOf(pos[0]) > Integer.valueOf(pos[1]) && column == 8) {
                        this.setForeground(Color.red);
                    }
                    return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                }
            };
            int i = 0;
            while (i < table.getColumnCount()) {
                table.getColumn(table.getColumnName(i)).setCellRenderer(tcr);
                ++i;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void clearJTbORFs() {
        DefaultTableModel model = new DefaultTableModel();
        model.addColumn("Label");
        model.addColumn("Frame");
        model.addColumn("Start");
        model.addColumn("Stop");
        model.addColumn("Length(nt|aa)");
        model.addColumn("IRES");
        this.JTbORFs.setModel(model);
        TableColumn C1 = this.JTbORFs.getColumnModel().getColumn(5);
        C1.setPreferredWidth(100);
        C1 = this.JTbORFs.getColumnModel().getColumn(4);
        C1.setPreferredWidth(90);
    }

    public void paintAllInOne(Graphics2D g2) {
        int centerX = 290;
        int centerY = 290;
        int outR = 250;
        int inR = 210;
        int txtR = inR - 10;
        if (this.cbxM.getSelectedIndex() == 2 & this.cbxMindex == -1) {
            this.clearJTbORFs();
            this.cbxMindex = 2;
        }
        g2.drawOval(centerX - outR, centerY - outR, 2 * outR, 2 * outR);
        g2.drawOval(centerX - inR, centerY - inR, 2 * inR, 2 * inR);
        int circlength = this.circLen;
        if (this.circStructure != null) {
            int angleStart;
            int angle;
            String circS = this.circStructure;
            String[] exons = circS.split(";");
            int[] exonLen = new int[exons.length];
            String[] exonLbl = new String[exons.length];
            int[] exonNo = new int[exons.length];
            int buf = 10;
            int i = 0;
            while (i < exons.length) {
                String[] s = exons[i].split(" ");
                exonLen[i] = Integer.valueOf(s[1]);
                exonLbl[i] = s[0];
                exonNo[i] = exonLbl[i].charAt(0) == 'i' ? buf++ : Integer.valueOf(exonLbl[i].replace("exon", "").replace("e", "")) % 10;
                ++i;
            }
            if (exonNo[0] == exonNo[exons.length - 1] & exonNo.length > 5) {
                exonNo[exonNo.length - 1] = 12;
            }
            int forward_exons_length = 0;
            int i2 = 0;
            while (i2 < exonLen.length) {
                angle = Math.round(360 * exonLen[i2] / circlength) + 1;
                angleStart = Math.round(360 * (forward_exons_length += exonLen[i2]) / circlength);
                g2.setColor(this.colors[exonNo[i2]]);
                g2.fillArc(centerX - outR, centerY - outR, 2 * outR, 2 * outR, 90 - angleStart, angle);
                ++i2;
            }
            if (this.seq != null & this.cbxM.getSelectedIndex() == 2 & tabbedPane.getSelectedIndex() == 0) {
                int i3;
                int c;
                int n;
                int[] rows = this.JTbORFs.getSelectedRows();
                if (rows.length > 0) {
                    n = rows.length;
                    c = 0;
                    int[] nArray = rows;
                    int n2 = rows.length;
                    int n3 = 0;
                    while (n3 < n2) {
                        String if_CDS_overlap;
                        i3 = nArray[n3];
                        String b = MainFrame.getValueAt(this.JTbORFs, i3, "Length(nt|aa)").trim();
                        if (b.indexOf("\u00d7") > 0) {
                            String[] bs = b.split("\u00d7");
                            int len = Integer.valueOf(bs[0]);
                            c += len / this.seq.length();
                        }
                        if ((if_CDS_overlap = MainFrame.getValueAt(this.JTbORFs, i3, "if_CDS_overlap")).equals("1")) {
                            ++c;
                        }
                        ++n3;
                    }
                    txtR = inR - n * 6 - 15 - c * 7;
                } else {
                    n = this.JTbORFs.getRowCount();
                    c = 0;
                    i3 = 0;
                    while (i3 < this.JTbORFs.getRowCount()) {
                        String b = MainFrame.getValueAt(this.JTbORFs, i3, "Length(nt|aa)").trim();
                        if (b.indexOf("\u00d7") > 0) {
                            String[] bs = b.split("\u00d7");
                            int len = Integer.valueOf(bs[0]);
                            c += len / this.seq.length();
                        }
                        ++i3;
                    }
                    txtR = inR - n * 6 - 15 - c * 7;
                }
            }
            g2.setColor(Color.white);
            g2.fillArc(centerX - inR, centerY - inR, 2 * inR, 2 * inR, 0, 360);
            g2.setColor(Color.black);
            forward_exons_length = 0;
            i = 0;
            while (i < exonLen.length) {
                angle = Math.round(360 * exonLen[i] / circlength);
                angleStart = Math.round(360 * (forward_exons_length += exonLen[i]) / circlength);
                int angelTxt = angleStart - Math.round(angle / 2);
                this.drawString(g2, angelTxt, centerX, centerY, txtR, exonLbl[i], Color.BLACK);
                ++i;
            }
        } else {
            g2.setColor(Color.red);
            g2.fillArc(centerX - outR, centerY - outR, 2 * outR, 2 * outR, 0, 360);
            g2.setColor(Color.white);
            g2.fillArc(centerX - inR, centerY - inR, 2 * inR, 2 * inR, 0, 360);
            g2.setColor(Color.black);
        }
        this.drawcircm6a_all(g2, centerX, centerY, inR);
        if (this.seq != null & this.cbxM.getSelectedIndex() == 2) {
            this.drawORFs(g2, centerX, centerY, inR);
        }
        if (this.circSymbol != null) {
            g2.setColor(Color.black);
            String symbol = this.circSymbol;
            Font font = new Font("Arial", 0, 20);
            FontMetrics fm = g2.getFontMetrics(font);
            g2.setFont(font);
            int width = fm.stringWidth(symbol);
            int fontHeight = fm.getHeight();
            g2.drawString(symbol, centerX - width / 2, centerY + fontHeight / 3);
        }
        this.drawTopRect(g2, circlength, centerX, centerY, outR);
        if (this.circFuntion != null & this.cbxM.getSelectedIndex() == 1) {
            this.drawFunction(g2, this.circFuntion, centerX, centerY, inR);
        }
        if (this.topLeftInf != null) {
            this.drawTopLeft(g2, Color.BLUE, this.topLeftInf);
        }
        if (this.bottomLeftInf != null) {
            this.drawBottomLeft(g2, Color.BLACK, this.bottomLeftInf, 620);
        }
        if (this.circPrimerInf != null) {
            this.drawPrimer(g2, this.circPrimerInf, centerX, centerY, outR);
        }
    }

    public void setModel(String Model) {
        this.Model = Model;
    }

    public void setParent_CDS_in_circ(String Parent_CDS_in_circ) {
        this.Parent_CDS_in_circ = Parent_CDS_in_circ;
    }

    public void setFeatures(List<String> features) {
        this.features = features;
    }

    public void setCircStructure(String circStructure) {
        this.circStructure = circStructure;
    }

    public void setCircLen(int circLen) {
        this.circLen = circLen;
    }

    public void setBottomLeftInf(String bottomLeftInf) {
        this.bottomLeftInf = bottomLeftInf;
    }

    public void setTopLeftInf(String topLeftInf) {
        this.topLeftInf = topLeftInf;
    }

    public void setFirstPaint(boolean firstpaint) {
        this.firstpaint = firstpaint;
    }

    public void setCircFuntion(String circFuntion) {
        this.circFuntion = circFuntion;
    }

    public void setCircPrimerInf(String circPrimerInf) {
        this.circPrimerInf = circPrimerInf;
    }

    public void setCircSymbol(String circSymbol) {
        this.circSymbol = circSymbol;
    }

    public void setSeq(String seq) {
        this.seq = seq;
    }

    public void setCbxMindex(int cbxMindex) {
        this.cbxMindex = cbxMindex;
    }

    public void setCirc_m6a_str(String circ_m6a_str) {
        this.circ_m6a_str = circ_m6a_str;
    }

    public void setChrNo(String chrNo) {
        this.chrNo = chrNo;
    }

    public void setBestTranscriptModel(DefaultTableModel BestTranscriptModel) {
        this.BestTranscriptModel = BestTranscriptModel;
    }

    public void setStrand(String strand) {
        this.strand = strand;
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    fmPic frame = new fmPic();
                    frame.setDefaultCloseOperation(3);
                    frame.setVisible(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public fmPic() {
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent arg0) {
                Robot r = null;
                try {
                    r = new Robot();
                }
                catch (AWTException e1) {
                    e1.printStackTrace();
                }
                if (fmPic.this.getWidth() > WIDTH) {
                    fmPic.this.setSize(WIDTH, fmPic.this.getHeight());
                    if (r != null) {
                        r.mouseRelease(16);
                    }
                }
                if (fmPic.this.getHeight() > 620) {
                    fmPic.this.setSize(fmPic.this.getWidth(), 620);
                    if (r != null) {
                        r.mouseRelease(16);
                    }
                }
            }

            @Override
            public void componentShown(ComponentEvent e) {
                if (fmPic.this.cbxMindex == 2) {
                    fmPic.this.cbxM.setSelectedIndex(fmPic.this.cbxMindex);
                }
            }
        });
        this.setDefaultCloseOperation(3);
        this.setBounds(0, 0, 1138, 620);
        this.contentPane = new JPanel();
        this.contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setContentPane(this.contentPane);
        this.contentPane.setLayout(null);
        this.panelLeft = new JPanel(){
            private static final long serialVersionUID = 1L;

            @Override
            public void paint(Graphics graphics) {
                if (fmPic.this.firstpaint) {
                    fmPic.this.firstpaint = false;
                    fmPic.this.initORF(Integer.parseInt(fmPic.this.cbxMimORFLen.getSelectedItem().toString()));
                }
                super.paint(graphics);
                Graphics2D g2 = (Graphics2D)graphics;
                RenderingHints renderHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                g2.setRenderingHints(renderHints);
                fmPic.this.paintAllInOne(g2);
                g2.dispose();
            }
        };
        this.panelLeft.setBounds(0, 0, 581, 581);
        this.panelLeft.setPreferredSize(new Dimension(400, 400));
        this.contentPane.add(this.panelLeft);
        this.panelLeft.setLayout(null);
        JButton btnSave = new JButton("Save");
        btnSave.setBounds(406, 549, 64, 23);
        this.panelLeft.add(btnSave);
        this.cbxM = new JComboBox();
        this.cbxM.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (fmPic.this.cbxM.getSelectedIndex() == 2) {
                    WIDTH = 1139;
                    if (fmPic.this.seq != null & tabbedPane.getSelectedIndex() == 0) {
                        fmPic.this.clearJTbORFs();
                        fmPic.this.firstpaint = true;
                    }
                } else {
                    WIDTH = 600;
                }
                fmPic.this.setSize(WIDTH, fmPic.this.getHeight());
                fmPic.this.panelLeft.repaint();
            }
        });
        this.cbxM.setModel(new DefaultComboBoxModel<String>(new String[]{"Default", "Function", "ORFs"}));
        if (this.cbxMindex != -1) {
            this.cbxM.setSelectedIndex(this.cbxMindex);
        }
        this.cbxM.setBounds(480, 550, 91, 21);
        this.panelLeft.add(this.cbxM);
        tabbedPane = new JTabbedPane(1);
        tabbedPane.setBounds(591, 0, 531, 581);
        this.contentPane.add(tabbedPane);
        this.scrollPane1 = new JScrollPane();
        tabbedPane.addTab("ORF and IRES", null, this.scrollPane1, null);
        this.scrollPane2 = new JScrollPane();
        tabbedPane.addTab("ORF and m6A", null, this.scrollPane2, null);
        tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                fmPic.this.panelLeft.repaint();
            }
        });
        JPanel panel_1 = new JPanel();
        panel_1.setBounds(591, 0, 531, 581);
        panel_1.setLayout(null);
        this.scrollPane1top = new JScrollPane();
        this.scrollPane1top.setBounds(10, 44, 504, 181);
        panel_1.add(this.scrollPane1top);
        this.scrollPane1.setViewportView(panel_1);
        this.JTbORFs = new JTable(){

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        this.JTbORFs.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    ArrayList<Integer> List_cds_pp = new ArrayList<Integer>();
                    fmPic.this.panelLeft.repaint();
                    int[] rows = fmPic.this.JTbORFs.getSelectedRows();
                    String s = "";
                    int[] nArray = rows;
                    int n = rows.length;
                    int n2 = 0;
                    while (n2 < n) {
                        int i = nArray[n2];
                        String ORF_SEQ = MainFrame.getValueAt(fmPic.this.JTbORFs, i, "ORF_SEQ");
                        String Label = MainFrame.getValueAt(fmPic.this.JTbORFs, i, "Label");
                        String AA_SEQ = MainFrame.getValueAt(fmPic.this.JTbORFs, i, "AA_SEQ");
                        String IRES_SEQ = MainFrame.getValueAt(fmPic.this.JTbORFs, i, "IRES_SEQ");
                        if (!IRES_SEQ.equals("")) {
                            s = String.valueOf(s) + ">" + Label + "_IRES_" + String.valueOf(IRES_SEQ.length()) + "\n";
                            s = String.valueOf(s) + IRES_SEQ + "\n\n";
                        }
                        String if_CDS_overlap = MainFrame.getValueAt(fmPic.this.JTbORFs, i, "if_CDS_overlap");
                        s = String.valueOf(s) + ">" + Label + "_RNA_" + String.valueOf(ORF_SEQ.length()) + "\n";
                        s = String.valueOf(s) + ORF_SEQ + "\n\n";
                        s = String.valueOf(s) + ">" + Label + "_Protein_" + String.valueOf(AA_SEQ.length()) + "\n";
                        if (if_CDS_overlap.equals("1")) {
                            String cdsStr = MainFrame.getValueAt(fmPic.this.JTbORFs, i, "cdsStr");
                            String[] cdsStrs = cdsStr.split(",");
                            int j = 0;
                            while (j < cdsStrs.length) {
                                String[] s1 = cdsStrs[j].split(" ");
                                int ss = Integer.valueOf(s1[2]) - 1;
                                int ll = Integer.valueOf(s1[3]);
                                List_cds_pp.add(ss + s.length());
                                List_cds_pp.add(ll);
                                ++j;
                            }
                        }
                        s = String.valueOf(s) + AA_SEQ + "\n\n";
                        ++n2;
                    }
                    String ss = s;
                    fmPic.this.textPane.setText(ss);
                    StyledDocument doc = fmPic.this.textPane.getStyledDocument();
                    SimpleAttributeSet setDefault = new SimpleAttributeSet();
                    StyleConstants.setBackground(setDefault, new Color(255, 255, 255));
                    StyleConstants.setForeground(setDefault, new Color(0, 0, 0));
                    doc.setCharacterAttributes(0, ss.length(), setDefault, true);
                    fmPic.this.textPane.setDocument(doc);
                    SimpleAttributeSet set = new SimpleAttributeSet();
                    set = new SimpleAttributeSet();
                    StyleConstants.setBackground(set, new Color(255, 0, 0));
                    StyleConstants.setForeground(set, new Color(255, 255, 255));
                    ArrayList<Integer> augs = fmPic.this.getStop(ss, "_RNA_");
                    int i = 0;
                    while (i < augs.size()) {
                        doc.setCharacterAttributes(augs.get(i), augs.get(i + 1), set, true);
                        i += 2;
                    }
                    fmPic.this.textPane.setDocument(doc);
                    set = new SimpleAttributeSet();
                    StyleConstants.setBackground(set, new Color(0, 255, 0));
                    augs = fmPic.this.getAUG(ss, "ATG", "_RNA_");
                    i = 0;
                    while (i < augs.size()) {
                        doc.setCharacterAttributes(augs.get(i), augs.get(i + 1), set, true);
                        i += 2;
                    }
                    augs = fmPic.this.getM(ss, "M", "_Protein_");
                    i = 0;
                    while (i < augs.size()) {
                        doc.setCharacterAttributes(augs.get(i), augs.get(i + 1), set, true);
                        i += 2;
                    }
                    fmPic.this.textPane.setDocument(doc);
                    set = new SimpleAttributeSet();
                    StyleConstants.setUnderline(set, true);
                    i = 0;
                    while (i < List_cds_pp.size()) {
                        doc.setCharacterAttributes((Integer)List_cds_pp.get(i), (Integer)List_cds_pp.get(i + 1), set, true);
                        i += 2;
                    }
                    fmPic.this.textPane.setDocument(doc);
                    if (List_cds_pp.size() == 0 | augs.size() == 0) {
                        return;
                    }
                    set = new SimpleAttributeSet();
                    StyleConstants.setBackground(set, new Color(0, 255, 0));
                    StyleConstants.setUnderline(set, true);
                    i = 0;
                    while (i < List_cds_pp.size()) {
                        int j = 0;
                        while (j < augs.size()) {
                            if (augs.get(j) >= (Integer)List_cds_pp.get(i) & augs.get(j) < (Integer)List_cds_pp.get(i) + (Integer)List_cds_pp.get(i + 1)) {
                                doc.setCharacterAttributes(augs.get(j), augs.get(j + 1), set, true);
                            }
                            j += 2;
                        }
                        i += 2;
                    }
                    fmPic.this.textPane.setDocument(doc);
                }
            }
        });
        this.scrollPane1top.add(this.JTbORFs);
        JScrollPane scrollPane1bottom = new JScrollPane();
        scrollPane1bottom.setHorizontalScrollBarPolicy(31);
        scrollPane1bottom.setBounds(10, 235, 504, 305);
        panel_1.add(scrollPane1bottom);
        this.textPane = new JTextPane(){};
        this.textPane.setEditorKit(new WrapEditorKit());
        this.textPane.setFont(new Font("Monospaced", 0, 15));
        scrollPane1bottom.setViewportView(this.textPane);
        JLabel lblMinimalOrfLength = new JLabel("Minimal ORF length (nt):");
        lblMinimalOrfLength.setBounds(10, 15, 154, 15);
        panel_1.add(lblMinimalOrfLength);
        this.cbxMimORFLen = new JComboBox();
        this.cbxMimORFLen.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (fmPic.this.seq != null) {
                    fmPic.this.firstpaint = true;
                    fmPic.this.clearJTbORFs();
                    fmPic.this.panelLeft.repaint();
                }
            }
        });
        this.cbxMimORFLen.setModel(new DefaultComboBoxModel<String>(new String[]{"30", "75", "150", "300", "600"}));
        this.cbxMimORFLen.setSelectedIndex(1);
        this.cbxMimORFLen.setToolTipText("");
        this.cbxMimORFLen.setBounds(157, 12, 50, 21);
        panel_1.add(this.cbxMimORFLen);
        this.pgbORF = new JProgressBar();
        this.pgbORF.setBounds(213, 15, 301, 14);
        this.pgbORF.setVisible(false);
        this.pgbORF.setIndeterminate(true);
        panel_1.add(this.pgbORF);
        JPanel panel_2 = new JPanel();
        panel_2.setBounds(591, 0, 531, 581);
        panel_2.setLayout(null);
        this.scrollPane2top = new JScrollPane();
        this.scrollPane2top.setBounds(10, 44, 504, 181);
        panel_2.add(this.scrollPane2top);
        this.scrollPane2.setViewportView(panel_2);
        this.JTbm6as = new JTable(){

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        this.JTbm6as.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            /*
             * Unable to fully structure code
             */
            @Override
            public void valueChanged(ListSelectionEvent e) {
                block8: {
                    block9: {
                        if (e.getValueIsAdjusting()) break block8;
                        fmPic.this.panelLeft.repaint();
                        if (fmPic.this.cbxM6a.getSelectedIndex() != 0) break block9;
                        rows = fmPic.access$4(fmPic.this).getSelectedRows();
                        s = "";
                        var7_6 = rows;
                        var6_8 = rows.length;
                        var5_10 = 0;
                        while (var5_10 < var6_8) {
                            block10: {
                                i = var7_6[var5_10];
                                chr = MainFrame.getValueAt(fmPic.access$4(fmPic.this), i, "chr");
                                Type = MainFrame.getValueAt(fmPic.access$4(fmPic.this), i, "Type");
                                seq = MainFrame.getValueAt(fmPic.access$4(fmPic.this), i, "seq");
                                chrLst = function.getChrList(chr);
                                start = Integer.valueOf(chrLst[1]);
                                end = Integer.valueOf(chrLst[2]);
                                f = "";
                                if (41 <= fmPic.access$15(fmPic.this)) ** GOTO lbl25
                                Position = Integer.valueOf(MainFrame.getValueAt(fmPic.access$4(fmPic.this), i, "Position"));
                                while (f.length() < Position - 1) {
                                    f = String.valueOf(f) + " ";
                                }
                                break block10;
lbl-1000:
                                // 1 sources

                                {
                                    f = String.valueOf(f) + " ";
lbl25:
                                    // 2 sources

                                    ** while (f.length() < 20)
                                }
                            }
                            st = start;
                            while (st <= end) {
                                f = String.valueOf(f) + "^";
                                ++st;
                            }
                            s = String.valueOf(s) + Type + " " + chr + "\n";
                            s = String.valueOf(s) + seq + "\n";
                            s = String.valueOf(s) + f + "\n";
                            ++var5_10;
                        }
                        fmPic.access$16(fmPic.this).setText(s);
                        break block8;
                    }
                    f = "";
                    while (f.length() < 20) {
                        f = String.valueOf(f) + " ";
                    }
                    f = String.valueOf(f) + "^";
                    rows = fmPic.access$4(fmPic.this).getSelectedRows();
                    s = "";
                    var8_15 = rows;
                    var7_7 = rows.length;
                    var6_9 = 0;
                    while (var6_9 < var7_7) {
                        i = var8_15[var6_9];
                        Fragment = MainFrame.getValueAt(fmPic.access$4(fmPic.this), i, "Fragment");
                        Type = MainFrame.getValueAt(fmPic.access$4(fmPic.this), i, "Type");
                        Position = MainFrame.getValueAt(fmPic.access$4(fmPic.this), i, "Position");
                        seq = MainFrame.getValueAt(fmPic.access$4(fmPic.this), i, "seq");
                        if (41 > fmPic.access$15(fmPic.this)) {
                            f = "";
                            Pos = Integer.valueOf(Position);
                            while (f.length() < Pos - 1) {
                                f = String.valueOf(f) + " ";
                            }
                            f = String.valueOf(f) + "^";
                        }
                        s = String.valueOf(s) + Type + " " + fmPic.this.cbxM6a.getSelectedItem().toString() + " " + Fragment + " " + Position + "\n";
                        s = String.valueOf(s) + seq + "\n";
                        s = String.valueOf(s) + f + "\n";
                        ++var6_9;
                    }
                    fmPic.access$16(fmPic.this).setText(s);
                }
            }
        });
        this.scrollPane2top.add(this.JTbm6as);
        JScrollPane scrollPane2bottom = new JScrollPane();
        scrollPane2bottom.setBounds(10, 235, 504, 305);
        panel_2.add(scrollPane2bottom);
        this.textArea2 = new JTextArea();
        this.textArea2.setLineWrap(true);
        this.textArea2.setFont(new Font("monospaced", 0, 14));
        scrollPane2bottom.setViewportView(this.textArea2);
        JLabel lblorfs = new JLabel("ORFs:");
        lblorfs.setBounds(10, 15, 50, 15);
        panel_2.add(lblorfs);
        this.cbxORFs = new JComboBox();
        this.cbxORFs.setMaximumRowCount(20);
        this.cbxORFs.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (fmPic.this.seq != null) {
                    fmPic.this.panelLeft.repaint();
                }
            }
        });
        this.cbxORFs.setModel(new DefaultComboBoxModel<String>(new String[]{"NULL"}));
        this.cbxORFs.setToolTipText("");
        this.cbxORFs.setBounds(47, 12, 71, 21);
        panel_2.add(this.cbxORFs);
        this.cbxM6a = new JComboBox();
        this.cbxM6a.setModel(new DefaultComboBoxModel<String>(new String[]{"High-confidence", "DDRAH"}));
        this.cbxM6a.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                fmPic.this.initm6a();
                fmPic.this.panelLeft.repaint();
            }
        });
        this.cbxM6a.setBounds(128, 12, 149, 21);
        panel_2.add(this.cbxM6a);
        if (this.seq != null) {
            List<Integer> orf = function.getORF(this.seq);
            int[][] rz = function.getORF(orf);
            System.out.println("Sorry,can`t find the Driver!");
            this.JTbORFs.setModel(function.getORF(rz, this.seq, 75, this.Model, this.features, null));
        }
        btnSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser fc = new JFileChooser();
                JFrame frm = new JFrame("java");
                String fileName = "circ" + fmPic.this.circSymbol;
                if (fmPic.this.topLeftInf != null) {
                    fileName = fmPic.this.topLeftInf.split("\n")[0];
                } else if (fmPic.this.bottomLeftInf != null) {
                    fileName = fmPic.this.bottomLeftInf.split("\n")[2].replace(":", "-");
                }
                File pdf = null;
                pdf = fmPic.this.pdfPath == null ? new File(String.valueOf(System.getProperty("user.dir")) + "\\" + fileName + ".pdf") : new File(String.valueOf(fmPic.this.pdfPath) + "\\" + fileName + ".pdf");
                fc.setDialogTitle("Save File");
                int flag = 0;
                fc.setSelectedFile(pdf);
                try {
                    flag = fc.showSaveDialog(frm);
                }
                catch (HeadlessException he) {
                    System.out.println("Save File Dialog ERROR!");
                }
                String pdfFullPath = null;
                if (flag != 0) {
                    return;
                }
                pdf = fc.getSelectedFile();
                pdfFullPath = pdf.getAbsolutePath();
                fmPic.this.pdfPath = pdf.getPath();
                Document document = new Document();
                PdfWriter writer = null;
                try {
                    writer = PdfWriter.getInstance((Document)document, (OutputStream)new FileOutputStream(new File(pdfFullPath)));
                }
                catch (FileNotFoundException e1) {
                    e1.printStackTrace();
                }
                catch (DocumentException e1) {
                    e1.printStackTrace();
                }
                document.open();
                PdfContentByte cb = writer.getDirectContent();
                PdfGraphics2D g2 = new PdfGraphics2D(cb, 600.0f, 620.0f);
                fmPic.this.paintAllInOne((Graphics2D)g2);
                g2.dispose();
                document.close();
            }
        });
    }

    static /* synthetic */ int access$15(fmPic fmPic2) {
        return fmPic2.circLen;
    }

    static /* synthetic */ JTextArea access$16(fmPic fmPic2) {
        return fmPic2.textArea2;
    }

    class WrapColumnFactory
    implements ViewFactory {
        WrapColumnFactory() {
        }

        @Override
        public View create(Element elem) {
            String kind = elem.getName();
            if (kind != null) {
                if (kind.equals("content")) {
                    return new WrapLabelView(elem);
                }
                if (kind.equals("paragraph")) {
                    return new ParagraphView(elem);
                }
                if (kind.equals("section")) {
                    return new BoxView(elem, 1);
                }
                if (kind.equals("component")) {
                    return new ComponentView(elem);
                }
                if (kind.equals("icon")) {
                    return new IconView(elem);
                }
            }
            return new LabelView(elem);
        }
    }

    class WrapEditorKit
    extends StyledEditorKit {
        ViewFactory defaultFactory;

        WrapEditorKit() {
            this.defaultFactory = new WrapColumnFactory();
        }

        @Override
        public ViewFactory getViewFactory() {
            return this.defaultFactory;
        }
    }

    class WrapLabelView
    extends LabelView {
        public WrapLabelView(Element elem) {
            super(elem);
        }

        @Override
        public int getBreakWeight(int axis, float pos, float len) {
            if (axis == 0) {
                this.checkPainter();
                int p0 = this.getStartOffset();
                int p1 = this.getGlyphPainter().getBoundedPosition(this, p0, pos, len);
                if (p1 == p0) {
                    return 0;
                }
                return 1000;
            }
            return super.getBreakWeight(axis, pos, len);
        }

        @Override
        public float getMinimumSpan(int axis) {
            switch (axis) {
                case 0: {
                    return 0.0f;
                }
                case 1: {
                    return super.getMinimumSpan(axis);
                }
            }
            throw new IllegalArgumentException("Invalid axis: " + axis);
        }

        @Override
        public View breakView(int axis, int p0, float pos, float len) {
            if (axis == 0) {
                this.checkPainter();
                int p1 = this.getGlyphPainter().getBoundedPosition(this, p0, pos, len);
                GlyphView v = (GlyphView)this.createFragment(p0, p1);
                return v;
            }
            return super.breakView(axis, p0, pos, len);
        }
    }
}

