/*
 * Decompiled with CFR 0.152.
 */
package circPrimer;

import circPrimer.fmPic;
import circPrimer.function;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.SimpleDateFormat;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class MainFrame
extends JFrame {
    private static final long serialVersionUID = 1L;
    private JPanel contentPane;
    private JTextField txtCircRNA;
    private JTable jtbSearchRZ;
    private JTextField txtF;
    private JTextField txtR;
    private JScrollPane scrollPaneSearch;
    private JScrollPane scrollPanePrimer;
    private JTable jtbPrimer;
    private fmPic fm = new fmPic();
    private JProgressBar pgbSearch;
    private JPanel panel;
    private JComboBox cbxOrganism;
    private JLabel lblSpecies;
    private static JComboBox cbxGTF;
    private JRadioButton rbtMultipleCircrnas;
    private JRadioButton rbtSingle;
    private JTextArea txtAcircRNAs;
    private JScrollPane scpTxtArea;
    private static String exepath;
    private static JButton btnCircbase;
    private static JButton btnAnnotate;
    private JScrollPane scrollPane_1;
    private JScrollPane scrollPane_2;
    private JScrollPane scrollPaneAnnotate;
    private JPanel panel_1;
    private JLabel lblF;
    private JLabel lblR;
    private JPanel panel_2;
    private JCheckBox cbxAnnotate;
    private JLabel lblSearchCount;
    private static JPanel panel_right;
    private JScrollPane scrollPaneSeq2;
    private JLabel lblCircrnaSequence;
    private static JTabbedPane tabbedPane;
    static MainFrame frame;
    private JTextArea txtAseq;
    private static JTextArea txtAseq2;
    private JScrollPane scrollPaneSeq1;
    private JTable jtbAnnotate;
    private JScrollPane scrollPane_3;
    private JPanel panel_3;
    JRadioButton rdbtnShowRna;
    JRadioButton rdbtnShowDna;
    private JLabel lblInputLineCount;
    private JLabel label;
    private JLabel lblNewLabel;
    private static JProgressBar progressBar;
    private JLabel lblDesinged;
    private JLabel lblFL;
    private JLabel lblRL;
    private JLabel lblPrimerColunt;
    private JLabel lblhelp;
    private JPanel panel_help;
    private JTextPane txtpnWew;
    private JLabel lblLength;
    private JPanel panel_4;
    private JPanel panel_5;
    private JRadioButton rbtPrimer1;
    private JRadioButton rbtPrimer2;
    private JButton btnTemplate;
    private JLabel lblNewLabel_1;
    private static String NEW_VER_URL;
    private static JLabel lblDownloadNewVer;
    private static JButton Check;
    private JPopupMenu popupMenuAnnotate;
    private JPopupMenu popupMenuSearch;
    private JPopupMenu popupMenuPimer;
    private static JLabel lblversion2;
    private JProgressBar pgbAnnotated;
    private JProgressBar pgbPrimer;

    static {
        NEW_VER_URL = "http://www.bioinf.com.cn/";
        lblversion2 = new JLabel("0");
    }

    public static void main(String[] args) {
        try {
            function.addlog();
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        if (args.length > 0) {
            function.comORF_IRES(args);
            return;
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    exepath = System.getProperty("user.dir");
                    frame = new MainFrame();
                    frame.setMinimumSize(new Dimension(1251, 703));
                    frame.setExtendedState(6);
                    frame.setVisible(true);
                    MainFrame.checkNewVersion(frame.getTitle());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public static void makeFace(JTable table, final int columnI) {
        if (table == null || table.getRowCount() == 0) {
            return;
        }
        try {
            DefaultTableCellRenderer tcr = new DefaultTableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    if (!table.getValueAt(row, columnI).toString().equals("")) {
                        this.setForeground(Color.red);
                    } else {
                        this.setForeground(Color.BLACK);
                    }
                    return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                }
            };
            int i = 0;
            while (i < table.getColumnCount()) {
                table.getColumn(table.getColumnName(i)).setCellRenderer(tcr);
                ++i;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void writeTXT(final String filePath, final JTable jtb, final String[] colNames, final String Split) {
        new Thread(){

            @Override
            public void run() {
                try {
                    progressBar.setVisible(true);
                    progressBar.setMinimum(0);
                    progressBar.setMaximum(jtb.getRowCount());
                    String inf = txtAseq2.getText();
                    progressBar.setValue(0);
                    File file = new File(filePath);
                    if (!file.exists()) {
                        file.createNewFile();
                    }
                    FileWriter fileWritter = new FileWriter(file.getAbsoluteFile());
                    BufferedWriter bw = new BufferedWriter(fileWritter);
                    String title = "";
                    int j = 0;
                    while (j < colNames.length) {
                        title = String.valueOf(title) + colNames[j] + Split;
                        ++j;
                    }
                    bw.write(String.valueOf(title.trim()) + "\n");
                    int i = 0;
                    while (i < jtb.getRowCount()) {
                        String l = "";
                        inf = String.valueOf(inf) + "Exporting ";
                        int j2 = 0;
                        while (j2 < colNames.length) {
                            l = String.valueOf(l) + MainFrame.getValueAt(jtb, i, colNames[j2]).trim() + Split;
                            bw.write(String.valueOf(MainFrame.getValueAt(jtb, i, colNames[j2]).trim()) + Split);
                            if (j2 == 1) {
                                inf = String.valueOf(inf) + l.replace(Split, " ") + "\n";
                            }
                            ++j2;
                        }
                        txtAseq2.setText(inf);
                        bw.write("\n");
                        progressBar.setValue(i + 1);
                        ++i;
                    }
                    bw.close();
                    inf = String.valueOf(inf) + "Done.\nThe output file could be found at: " + filePath + "\n";
                    txtAseq2.setText(inf);
                    progressBar.setVisible(false);
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        }.start();
    }

    public static void writeFasta(final String filePath, final JTable jtb, final String[] colNames) {
        new Thread(){

            @Override
            public void run() {
                try {
                    progressBar.setVisible(true);
                    progressBar.setMinimum(0);
                    progressBar.setMaximum(jtb.getRowCount());
                    String inf = txtAseq2.getText();
                    progressBar.setValue(0);
                    File file = new File(filePath);
                    if (!file.exists()) {
                        file.createNewFile();
                    }
                    FileWriter fileWritter = new FileWriter(file.getAbsoluteFile());
                    BufferedWriter bw = new BufferedWriter(fileWritter);
                    int i = 0;
                    while (i < jtb.getRowCount()) {
                        String name = MainFrame.getValueAt(jtb, i, colNames[0]);
                        String seq = MainFrame.getValueAt(jtb, i, colNames[1]);
                        inf = String.valueOf(inf) + "Exporting " + name + "\n";
                        txtAseq2.setText(inf);
                        bw.write(">" + name + "\n");
                        bw.write(String.valueOf(seq) + "\n");
                        progressBar.setValue(i + 1);
                        ++i;
                    }
                    bw.close();
                    inf = String.valueOf(inf) + "Done.\nThe output file could be found at: " + filePath + "\n";
                    txtAseq2.setText(inf);
                    progressBar.setVisible(false);
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        }.start();
    }

    public static void checkNewVersion(String title) {
        int dbv2;
        int v2;
        double dbv1;
        String[] s = title.split(" ");
        String[][] inf = function.getVersionInf(s[0], s[1], lblversion2.getText());
        if (inf[0][1].equals("0")) {
            btnAnnotate.setEnabled(false);
            btnCircbase.setEnabled(false);
            Check.setEnabled(false);
            panel_right.setEnabled(false);
            JOptionPane.showMessageDialog(null, inf[0][2], "Message", -1);
            NEW_VER_URL = inf[0][3];
            lblDownloadNewVer.setVisible(true);
        }
        if (inf[1][0].equals("")) {
            return;
        }
        double v1 = Double.valueOf(s[1]);
        if (v1 > (dbv1 = Double.valueOf(inf[1][0]).doubleValue())) {
            return;
        }
        if (v1 == dbv1 & (v2 = Integer.valueOf(lblversion2.getText()).intValue()) >= (dbv2 = Integer.valueOf(inf[1][4]).intValue())) {
            return;
        }
        JOptionPane.showMessageDialog(null, inf[1][2], "Message", -1);
        NEW_VER_URL = inf[1][3];
        Desktop desktop = Desktop.getDesktop();
        URI uri = null;
        try {
            uri = new URI(NEW_VER_URL);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        try {
            desktop.browse(uri);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        lblDownloadNewVer.setVisible(true);
    }

    public void checkCircRNAInput(String CircRNAInput) {
        String s = CircRNAInput.trim();
        File file = new File(CircRNAInput);
        if (file.exists()) {
            function.searchCircRNA(s, "path");
        } else if (s.replace("-", "_").indexOf("_circ_") != -1) {
            function.searchCircRNA(s.replace("-", "_"), "circbaseID");
        } else if (s.indexOf("chr") == 0) {
            function.searchCircRNA(s, "chr");
        } else {
            function.searchCircRNA(s, "symbol");
        }
    }

    public void setCbxItem(JComboBox cbx, String itemString) {
        int i = 0;
        while (i < cbx.getItemCount()) {
            if (itemString.equals(cbx.getItemAt(i).toString())) {
                cbx.setSelectedIndex(i);
                return;
            }
            ++i;
        }
    }

    public void showCircRNA(String chr, String refGene, String primerInf, String topLeftStr, String seq, String Exon_Intron_Function, String Parent_CDS_in_circ) {
        if (Exon_Intron_Function.equals("None")) {
            if (primerInf == null) {
                JOptionPane.showMessageDialog(null, "No parental gene was found for " + chr, "Message", -1);
            }
            this.fm.setVisible(false);
            this.fm.setFirstPaint(true);
            this.fm.setCbxMindex(-1);
            this.fm.setCircLen(seq.length());
            this.fm.setTopLeftInf(topLeftStr);
            this.fm.setBottomLeftInf(null);
            this.fm.setCircStructure(null);
            this.fm.setCircFuntion(null);
            this.fm.setParent_CDS_in_circ(null);
            this.fm.setCircSymbol(null);
            this.fm.setSeq(seq);
            this.fm.setCircPrimerInf(primerInf);
            this.fm.setDefaultCloseOperation(2);
            this.fm.setVisible(true);
            return;
        }
        String[] chrLst = function.getChrList(chr);
        String chrNo = chrLst[0];
        int start = Integer.valueOf(chrLst[1]);
        int end = Integer.valueOf(chrLst[2]);
        String[] EIFs = Exon_Intron_Function.split("~");
        String Circ_Exon_Intron = EIFs[0];
        if (Circ_Exon_Intron.equals("null")) {
            Circ_Exon_Intron = null;
        }
        String circFuntion = null;
        if (EIFs.length > 1) {
            circFuntion = EIFs[1];
        }
        if (circFuntion.equals("null")) {
            circFuntion = null;
        }
        String[] bufs = Circ_Exon_Intron.split("#");
        String circStructure = bufs[4];
        String Function_Str = function.getCirc_Function_Str(Circ_Exon_Intron, circFuntion);
        String bottomLeftInf = String.valueOf(bufs[6]) + "\n" + bufs[0] + "\n" + bufs[3] + "\n" + "chr:" + chrNo + chrLst[1] + "-" + chrLst[2] + bufs[1];
        Items items = (Items)this.cbxOrganism.getSelectedItem();
        String org = items.getValue();
        String hg = MainFrame.gethg(refGene);
        String[] positions = function.getCirc_m6a(org, chrNo, start, end, bufs[1], hg);
        String Circ_m6a_str = function.getCirc_m6a_str(Circ_Exon_Intron, positions);
        String RNA_SEQ = function.getRNA_SEQ(hg, chrNo, chrLst[1], chrLst[2], bufs[1], bufs[5]);
        this.fm.setVisible(false);
        this.fm.setFirstPaint(true);
        this.fm.setChrNo(chrNo);
        this.fm.setStrand(bufs[1]);
        this.fm.setCbxMindex(-1);
        this.fm.setParent_CDS_in_circ(Parent_CDS_in_circ);
        this.fm.setCircLen(Integer.valueOf(bufs[6]));
        this.fm.setTopLeftInf(topLeftStr);
        this.fm.setBottomLeftInf(bottomLeftInf);
        this.fm.setCircStructure(circStructure);
        this.fm.setCircFuntion(Function_Str);
        this.fm.setCirc_m6a_str(Circ_m6a_str);
        this.fm.setCircSymbol(bufs[0]);
        this.fm.setSeq(RNA_SEQ);
        this.fm.setCircPrimerInf(primerInf);
        this.fm.setDefaultCloseOperation(2);
        this.fm.setVisible(true);
    }

    public void annotateCircRNA(String circRNA, String chr, String refGene, String primerInf, String topLeftStr, String seq) {
        String[] chrLst = function.getChrList(chr);
        String chrNo = chrLst[0];
        int start = Integer.valueOf(chrLst[1]);
        int end = Integer.valueOf(chrLst[2]);
        DefaultTableModel model = function.getBestTranscript(refGene.toString(), chrNo, String.valueOf(start), String.valueOf(end));
        if (model == null) {
            if (primerInf == null) {
                JOptionPane.showMessageDialog(null, "No parental gene was found for " + chr, "Message", -1);
            }
            this.fm.setVisible(false);
            this.fm.setFirstPaint(true);
            this.fm.setParent_CDS_in_circ(null);
            this.fm.setCbxMindex(-1);
            this.fm.setCircLen(seq.length());
            this.fm.setTopLeftInf(topLeftStr);
            this.fm.setBottomLeftInf(null);
            this.fm.setCircStructure(null);
            this.fm.setCircFuntion(null);
            this.fm.setCircSymbol(null);
            this.fm.setSeq(seq);
            this.fm.setCircPrimerInf(primerInf);
            this.fm.setDefaultCloseOperation(2);
            this.fm.setVisible(true);
            function.update_Exon_Intron_Function(circRNA, "None");
            return;
        }
        String Circ_Exon_Intron = function.getCirc_Exon_Intron(start, end, function.getExon_Intron(model, start, end));
        String[] bufs = Circ_Exon_Intron.split("#");
        String circStructure = bufs[4];
        String circFuntion = function.getCirc_Function(model, start, end);
        String Function_Str = function.getCirc_Function_Str(Circ_Exon_Intron, circFuntion);
        String bottomLeftInf = String.valueOf(bufs[6]) + "\n" + bufs[0] + "\n" + bufs[3] + "\n" + "chr:" + chrNo + chrLst[1] + "-" + chrLst[2] + bufs[1];
        Items items = (Items)this.cbxOrganism.getSelectedItem();
        String org = items.getValue();
        String hg = MainFrame.gethg(refGene);
        String[] positions = function.getCirc_m6a(org, chrNo, start, end, bufs[1], hg);
        String Circ_m6a_str = function.getCirc_m6a_str(Circ_Exon_Intron, positions);
        String RNA_SEQ = function.getRNA_SEQ(hg, chrNo, chrLst[1], chrLst[2], bufs[1], bufs[5]);
        String Parent_SEQ = function.getParent_SEQ(model, Circ_Exon_Intron);
        String Parent_CDS_in_circ = function.getParent_CDS_in_circ(RNA_SEQ, Parent_SEQ, Circ_Exon_Intron);
        this.fm.setVisible(false);
        this.fm.setFirstPaint(true);
        this.fm.setChrNo(chrNo);
        this.fm.setParent_CDS_in_circ(Parent_CDS_in_circ);
        if (Parent_CDS_in_circ == null) {
            Parent_CDS_in_circ = "None";
        }
        function.update_all_Parent_CDS_in_circ(circRNA, Parent_CDS_in_circ);
        this.fm.setStrand(bufs[1]);
        this.fm.setCbxMindex(-1);
        this.fm.setCircLen(Integer.valueOf(bufs[6]));
        this.fm.setTopLeftInf(topLeftStr);
        this.fm.setBottomLeftInf(bottomLeftInf);
        this.fm.setCircStructure(circStructure);
        this.fm.setCircFuntion(Function_Str);
        this.fm.setCirc_m6a_str(Circ_m6a_str);
        this.fm.setCircSymbol(bufs[0]);
        this.fm.setSeq(RNA_SEQ);
        this.fm.setCircPrimerInf(primerInf);
        this.fm.setDefaultCloseOperation(2);
        this.fm.setVisible(true);
        function.update_Exon_Intron_Function(circRNA, String.valueOf(Circ_Exon_Intron) + "~" + circFuntion);
    }

    public String[] annotateCircRNA(Item item, String chr) {
        String[] chrLst = function.getChrList(chr);
        String chrNo = chrLst[0];
        int start = Integer.valueOf(chrLst[1]);
        int end = Integer.valueOf(chrLst[2]);
        String refGene = item.getrefGene();
        String hg = item.gethg();
        DefaultTableModel model = function.getBestTranscript(refGene, chrNo, String.valueOf(start), String.valueOf(end));
        if (model == null) {
            return null;
        }
        String Circ_Exon_Intron = function.getCirc_Exon_Intron(start, end, function.getExon_Intron(model, start, end));
        String[] bufs = Circ_Exon_Intron.split("#");
        String circStructure = bufs[4];
        String circFuntion = function.getCirc_Function(model, start, end);
        String Function_Str = function.getCirc_Function_Str(Circ_Exon_Intron, circFuntion);
        Items items = (Items)this.cbxOrganism.getSelectedItem();
        String org = items.getValue();
        String[] positions = function.getCirc_m6a(org, chrNo, start, end, bufs[1], hg);
        String Circ_m6a_str = function.getCirc_m6a_str(Circ_Exon_Intron, positions);
        String DNA_SEQ = function.getDNA_SEQ(hg, chrNo, chrLst[1], chrLst[2], bufs[1]);
        String RNA_SEQ = function.getRNA_SEQ(hg, chrNo, chrLst[1], chrLst[2], bufs[1], bufs[5]);
        String Parent_SEQ = function.getParent_SEQ(model, Circ_Exon_Intron);
        String Parent_CDS_in_circ = function.getParent_CDS_in_circ(RNA_SEQ, Parent_SEQ, Circ_Exon_Intron);
        String[] rz = new String[]{bufs[0], bufs[1], circStructure, Function_Str, DNA_SEQ, RNA_SEQ, String.valueOf(bufs[6]) + "\n" + bufs[0] + "\n" + bufs[3] + "\n" + "chr:" + chrNo + chrLst[1] + "-" + chrLst[2] + bufs[1], Circ_m6a_str, Parent_CDS_in_circ};
        return rz;
    }

    private static String gethg(String refGene) {
        String hg = "";
        int i = 0;
        while (i < cbxGTF.getItemCount()) {
            Item item = (Item)cbxGTF.getItemAt(i);
            if (item.getrefGene().equals(refGene)) {
                hg = item.gethg();
                break;
            }
            ++i;
        }
        return hg;
    }

    private static int getColumnByName(JTable table, String name) {
        int i = 0;
        while (i < table.getColumnCount()) {
            if (table.getColumnName(i).equals(name)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static String getValueAt(JTable table, int rowi, String colname) {
        if (table.getRowCount() == 0) {
            return "";
        }
        String rz = "";
        int j = MainFrame.getColumnByName(table, colname);
        if (j == -1) {
            return "";
        }
        if (table.getValueAt(rowi, j) != null) {
            rz = table.getValueAt(rowi, j).toString();
        }
        return rz;
    }

    private void init_cbxOrganism() {
        DefaultTableModel model = function.getGTF_LIST();
        JTable tb = new JTable(model);
        this.cbxOrganism.removeAllItems();
        int i = 0;
        while (i < model.getRowCount()) {
            String Organism = MainFrame.getValueAt(tb, i, "Organism");
            String Org = MainFrame.getValueAt(tb, i, "Org");
            Items items = new Items(Organism, Org);
            boolean exists = false;
            int index = 0;
            while (index < this.cbxOrganism.getItemCount() && !exists) {
                if (Organism.equals(this.cbxOrganism.getItemAt(index).toString())) {
                    exists = true;
                }
                ++index;
            }
            if (!exists) {
                this.cbxOrganism.addItem(items);
            }
            ++i;
        }
    }

    private void init_cbxGTF(String Organism) {
        DefaultTableModel model = function.getGTF_LIST();
        JTable tb = new JTable(model);
        cbxGTF.removeAllItems();
        int i = 0;
        while (i < model.getRowCount()) {
            String Organism2 = MainFrame.getValueAt(tb, i, "Organism");
            if (Organism2.equals(Organism)) {
                String hg = MainFrame.getValueAt(tb, i, "hg");
                String GTF = MainFrame.getValueAt(tb, i, "GTF");
                String refGene = MainFrame.getValueAt(tb, i, "refGene");
                Item item = new Item(GTF, hg, refGene);
                cbxGTF.addItem(item);
            }
            ++i;
        }
    }

    private void resize_panel_left() {
        if (this.rbtMultipleCircrnas.isSelected()) {
            this.rbtSingle.setSelected(false);
            this.scpTxtArea.setVisible(true);
            this.txtCircRNA.setVisible(false);
            btnCircbase.setVisible(false);
            btnAnnotate.setBounds(btnAnnotate.getX(), this.scpTxtArea.getY() + this.scpTxtArea.getHeight() + 20, btnAnnotate.getWidth(), btnAnnotate.getHeight());
            this.lblNewLabel.setVisible(true);
            this.lblInputLineCount.setVisible(true);
            this.txtpnWew.setText("One circRNA per line. \nAccepted data:circBase ID (e.g. hsa_circ_0000002) and chr (e.g. chr1:1158623-1159348)");
        } else {
            progressBar.setVisible(false);
            this.rbtSingle.setSelected(true);
            this.scpTxtArea.setVisible(false);
            this.txtCircRNA.setVisible(true);
            btnCircbase.setVisible(true);
            btnAnnotate.setBounds(btnAnnotate.getX(), this.txtCircRNA.getY() + this.txtCircRNA.getHeight() + 20, btnAnnotate.getWidth(), btnAnnotate.getHeight());
            btnCircbase.setBounds(btnCircbase.getX(), this.txtCircRNA.getY() + this.txtCircRNA.getHeight() + 20, btnCircbase.getWidth(), btnCircbase.getHeight());
            this.lblNewLabel.setVisible(false);
            this.lblInputLineCount.setVisible(false);
            this.txtpnWew.setText("CircBase ID (e.g. hsa_circ_0000002) and chr (e.g. chr1:1158623-1159348) can be input for annotating, and circBase ID, chr and gene symbol (e.g. SDF4) for searching circRNA in circBase.");
        }
        this.panel.setBounds(this.panel.getX(), this.panel.getY(), this.panel.getWidth(), frame.getHeight() - 60);
        progressBar.setBounds(10, this.panel.getHeight() - 25, 296, 14);
        this.panel_help.setBounds(this.panel_help.getX(), this.panel.getHeight() - 30 - this.panel_help.getHeight(), this.panel_help.getWidth(), this.panel_help.getHeight());
        this.txtpnWew.setBounds(this.txtpnWew.getX(), btnAnnotate.getY() + 35, this.txtpnWew.getWidth(), this.txtpnWew.getHeight());
    }

    private void resize_tabpanel() {
        tabbedPane.setBounds(tabbedPane.getX(), tabbedPane.getY(), tabbedPane.getWidth(), frame.getHeight() - 60);
        this.scrollPanePrimer.setBounds(10, 80, this.scrollPanePrimer.getWidth(), tabbedPane.getHeight() - 120);
        this.scrollPaneSearch.setBounds(10, 60, this.scrollPaneSearch.getWidth(), tabbedPane.getHeight() - 100);
        this.scrollPaneAnnotate.setBounds(10, 60, this.scrollPaneAnnotate.getWidth(), tabbedPane.getHeight() - 100);
    }

    private void resize_panel_right() {
        panel_right.setBounds(panel_right.getX(), panel_right.getY(), frame.getWidth() - tabbedPane.getWidth() - this.panel.getWidth() - 55, frame.getHeight() - 60);
        this.scrollPaneSeq1.setBounds(this.scrollPaneSeq1.getX(), this.scrollPaneSeq1.getY(), panel_right.getWidth() - 20, this.scrollPaneSeq1.getHeight());
        this.scrollPaneSeq2.setBounds(this.scrollPaneSeq2.getX(), this.scrollPaneSeq2.getY(), panel_right.getWidth() - 20, panel_right.getHeight() - this.scrollPaneSeq1.getHeight() - 80);
        this.scrollPaneSeq1.setViewportView(this.txtAseq);
        this.scrollPaneSeq2.setViewportView(txtAseq2);
        if (this.scrollPaneSeq2.getWidth() > this.panel_4.getWidth() + this.panel_5.getWidth()) {
            this.panel_4.setVisible(true);
        } else {
            this.panel_4.setVisible(false);
        }
        this.panel_4.setBounds(this.scrollPaneSeq2.getWidth() - this.panel_4.getWidth() + 8, this.panel_5.getY(), this.panel_4.getWidth(), this.panel_4.getHeight());
    }

    public MainFrame() {
        this.setTitle("circPrimer 2.0");
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent arg0) {
                MainFrame.this.resize_tabpanel();
                MainFrame.this.resize_panel_left();
                MainFrame.this.resize_panel_right();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent arg0) {
                MainFrame.this.repaint();
            }
        });
        this.setDefaultCloseOperation(3);
        this.setBounds(100, 100, 1251, 703);
        this.contentPane = new JPanel();
        this.contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setContentPane(this.contentPane);
        this.contentPane.setLayout(null);
        this.scrollPaneAnnotate = new JScrollPane();
        this.scrollPaneAnnotate.setBounds(10, 60, 361, 195);
        DefaultTableModel model1 = new DefaultTableModel();
        model1.addColumn("chr");
        model1.addColumn("Symbol");
        this.jtbAnnotate = new JTable(model1);
        this.jtbAnnotate.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    MainFrame.this.pgbAnnotated.setVisible(true);
                    int rowi = MainFrame.this.jtbAnnotate.getSelectedRow();
                    if (rowi == -1) {
                        MainFrame.this.pgbAnnotated.setVisible(false);
                        return;
                    }
                    String Homeotic_Gene = MainFrame.getValueAt(MainFrame.this.jtbAnnotate, rowi, "Homeotic_Gene");
                    String circRNA = MainFrame.getValueAt(MainFrame.this.jtbAnnotate, rowi, "circRNA");
                    String seq = MainFrame.getValueAt(MainFrame.this.jtbAnnotate, rowi, "Seq");
                    if (Homeotic_Gene.length() > 0) {
                        String Homeotic_Gene_Seq = function.getCircRNASeq(Homeotic_Gene);
                        String s = function.clustalw2(circRNA, seq, Homeotic_Gene, Homeotic_Gene_Seq);
                        txtAseq2.setText(s);
                    } else {
                        txtAseq2.setText("");
                    }
                    String circStructure = MainFrame.getValueAt(MainFrame.this.jtbAnnotate, rowi, "circStructure");
                    String Function_Str = MainFrame.getValueAt(MainFrame.this.jtbAnnotate, rowi, "Function_Str");
                    String Symbol = MainFrame.getValueAt(MainFrame.this.jtbAnnotate, rowi, "Symbol");
                    String DNA_SEQ = MainFrame.getValueAt(MainFrame.this.jtbAnnotate, rowi, "DNA_SEQ");
                    String RNA_SEQ = MainFrame.getValueAt(MainFrame.this.jtbAnnotate, rowi, "RNA_SEQ");
                    String m6a = MainFrame.getValueAt(MainFrame.this.jtbAnnotate, rowi, "m6a");
                    String chr = MainFrame.getValueAt(MainFrame.this.jtbAnnotate, rowi, "chr");
                    String Parent_CDS_in_circ = MainFrame.getValueAt(MainFrame.this.jtbAnnotate, rowi, "Parent_CDS_in_circ");
                    if (Parent_CDS_in_circ.equals("")) {
                        Parent_CDS_in_circ = null;
                    }
                    String[] chrLst = function.getChrList(chr);
                    String chrNo = chrLst[0];
                    String strand = MainFrame.getValueAt(MainFrame.this.jtbAnnotate, rowi, "strand");
                    if (MainFrame.this.rdbtnShowRna.isSelected()) {
                        MainFrame.this.txtAseq.setText(RNA_SEQ);
                    } else {
                        MainFrame.this.txtAseq.setText(DNA_SEQ);
                    }
                    String topLeftStr = circRNA;
                    if (topLeftStr.length() > 0) {
                        topLeftStr = String.valueOf(topLeftStr) + " " + MainFrame.getValueAt(MainFrame.this.jtbAnnotate, rowi, "SymbolcircBase") + "\n";
                        topLeftStr = String.valueOf(topLeftStr) + MainFrame.getValueAt(MainFrame.this.jtbAnnotate, rowi, "chr") + "\n";
                        topLeftStr = String.valueOf(topLeftStr) + MainFrame.getValueAt(MainFrame.this.jtbAnnotate, rowi, "NM") + "\n";
                        topLeftStr = String.valueOf(topLeftStr) + MainFrame.getValueAt(MainFrame.this.jtbAnnotate, rowi, "Length");
                    }
                    String bottomLeftInf = MainFrame.getValueAt(MainFrame.this.jtbAnnotate, rowi, "bottomLeftInf");
                    MainFrame.this.fm.setVisible(false);
                    MainFrame.this.fm.setFirstPaint(true);
                    MainFrame.this.fm.setParent_CDS_in_circ(Parent_CDS_in_circ);
                    MainFrame.this.fm.setChrNo(chrNo);
                    MainFrame.this.fm.setStrand(strand);
                    MainFrame.this.fm.setCbxMindex(-1);
                    MainFrame.this.fm.setCircPrimerInf(null);
                    MainFrame.this.fm.setCircLen(RNA_SEQ.length());
                    MainFrame.this.fm.setTopLeftInf(topLeftStr);
                    MainFrame.this.fm.setBottomLeftInf(bottomLeftInf);
                    MainFrame.this.fm.setCircStructure(circStructure);
                    MainFrame.this.fm.setCircFuntion(Function_Str);
                    MainFrame.this.fm.setCirc_m6a_str(m6a);
                    MainFrame.this.fm.setCircSymbol(Symbol);
                    MainFrame.this.fm.setSeq(RNA_SEQ);
                    MainFrame.this.fm.setDefaultCloseOperation(2);
                    ((MainFrame)MainFrame.this).fm.panelLeft.repaint();
                    MainFrame.this.fm.setVisible(true);
                    MainFrame.this.pgbAnnotated.setVisible(false);
                    MainFrame.this.jtbAnnotate.getSelectionModel().clearSelection();
                }
            }
        });
        this.jtbAnnotate.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 3) {
                    MainFrame.this.popupMenuAnnotate.show(MainFrame.this.jtbAnnotate, e.getX(), e.getY());
                }
            }
        });
        TableColumn C1 = this.jtbAnnotate.getColumnModel().getColumn(0);
        C1.setPreferredWidth(170);
        this.scrollPaneAnnotate.setViewportView(this.jtbAnnotate);
        this.popupMenuAnnotate = new JPopupMenu();
        JMenuItem menuItemAnnotateTxt = new JMenuItem("Export as text");
        menuItemAnnotateTxt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String[] colNames = new String[]{"circRNA", "chr", "strand", "Symbol", "NM", "DNA_SEQ", "RNA_SEQ"};
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                String fname = "Annotated Results " + df.format(System.currentTimeMillis()).replace(":", "-");
                String filePath = String.valueOf(exepath) + "\\" + fname + ".txt";
                MainFrame.writeTXT(filePath, MainFrame.this.jtbAnnotate, colNames, "\t");
            }
        });
        this.popupMenuAnnotate.add(menuItemAnnotateTxt);
        JMenuItem menuItemAnnotateCsv = new JMenuItem("Export as csv");
        menuItemAnnotateCsv.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String[] colNames = new String[]{"circRNA", "chr", "strand", "Symbol", "NM", "RNA_SEQ"};
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                String fname = "Annotated Results " + df.format(System.currentTimeMillis()).replace(":", "-");
                String filePath = String.valueOf(exepath) + "\\" + fname + ".csv";
                MainFrame.writeTXT(filePath, MainFrame.this.jtbAnnotate, colNames, ",");
            }
        });
        this.popupMenuAnnotate.add(menuItemAnnotateCsv);
        JMenuItem menuItemAnnotateFastaRNA = new JMenuItem("Export RNA Seq. as Fasta Format");
        menuItemAnnotateFastaRNA.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String[] colNames = new String[]{"chr", "RNA_SEQ"};
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                String fname = "Annotated Results RNA Seq. Fasta " + df.format(System.currentTimeMillis()).replace(":", "-");
                String filePath = String.valueOf(exepath) + "\\" + fname + ".txt";
                MainFrame.writeFasta(filePath, MainFrame.this.jtbAnnotate, colNames);
            }
        });
        this.popupMenuAnnotate.add(menuItemAnnotateFastaRNA);
        JMenuItem menuItemAnnotateFastaDNA = new JMenuItem("Export DNA Seq. as Fasta Format");
        menuItemAnnotateFastaDNA.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String[] colNames = new String[]{"chr", "DNA_SEQ"};
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                String fname = "Annotated Results DNA Seq. Fasta " + df.format(System.currentTimeMillis()).replace(":", "-");
                String filePath = String.valueOf(exepath) + "\\" + fname + ".txt";
                MainFrame.writeFasta(filePath, MainFrame.this.jtbAnnotate, colNames);
            }
        });
        this.popupMenuAnnotate.add(menuItemAnnotateFastaDNA);
        this.scrollPaneAnnotate.add(this.popupMenuAnnotate);
        this.scrollPaneSearch = new JScrollPane();
        this.scrollPaneSearch.setBounds(10, 60, 361, 195);
        DefaultTableModel model0 = new DefaultTableModel();
        model0.addColumn("circRNA");
        model0.addColumn("chr");
        model0.addColumn("Symbol");
        this.jtbSearchRZ = new JTable(model0);
        TableColumn Column1 = this.jtbSearchRZ.getColumnModel().getColumn(0);
        Column1.setPreferredWidth(110);
        TableColumn Column2 = this.jtbSearchRZ.getColumnModel().getColumn(1);
        Column2.setPreferredWidth(170);
        this.jtbSearchRZ.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    new Thread(){

                        @Override
                        public void run() {
                            MainFrame.this.pgbSearch.setVisible(true);
                            int rowi = MainFrame.this.jtbSearchRZ.getSelectedRow();
                            if (rowi == -1) {
                                MainFrame.this.pgbSearch.setVisible(false);
                                return;
                            }
                            String seq = MainFrame.getValueAt(MainFrame.this.jtbSearchRZ, rowi, "seq");
                            MainFrame.this.txtAseq.setText(seq);
                            String Homeotic_Gene = MainFrame.getValueAt(MainFrame.this.jtbSearchRZ, rowi, "Homeotic_Gene");
                            String circRNA = MainFrame.getValueAt(MainFrame.this.jtbSearchRZ, rowi, "circRNA");
                            if (Homeotic_Gene.length() > 0) {
                                String Homeotic_Gene_Seq = function.getCircRNASeq(Homeotic_Gene);
                                String s = function.clustalw2(circRNA, seq, Homeotic_Gene, Homeotic_Gene_Seq);
                                txtAseq2.setText(s);
                            } else {
                                txtAseq2.setText("");
                            }
                            if (!MainFrame.this.cbxAnnotate.isSelected()) {
                                MainFrame.this.pgbSearch.setVisible(false);
                                return;
                            }
                            String org = MainFrame.getValueAt(MainFrame.this.jtbSearchRZ, rowi, "org");
                            String chrStr = MainFrame.getValueAt(MainFrame.this.jtbSearchRZ, rowi, "chr");
                            String refGene = "";
                            if (org.equals("hsa")) {
                                MainFrame.this.setCbxItem(MainFrame.this.cbxOrganism, "Homo Sapiens");
                            }
                            if (org.equals("mmu")) {
                                MainFrame.this.setCbxItem(MainFrame.this.cbxOrganism, "Mus Musculus");
                            }
                            cbxGTF.setSelectedIndex(0);
                            Item item = (Item)cbxGTF.getSelectedItem();
                            refGene = item.getrefGene();
                            String topLeftStr = String.valueOf(circRNA) + " " + MainFrame.getValueAt(MainFrame.this.jtbSearchRZ, rowi, "Symbol") + "\n";
                            topLeftStr = String.valueOf(topLeftStr) + MainFrame.getValueAt(MainFrame.this.jtbSearchRZ, rowi, "chr") + "\n";
                            topLeftStr = String.valueOf(topLeftStr) + MainFrame.getValueAt(MainFrame.this.jtbSearchRZ, rowi, "NM") + "\n";
                            topLeftStr = String.valueOf(topLeftStr) + MainFrame.getValueAt(MainFrame.this.jtbSearchRZ, rowi, "Length");
                            String Exon_Intron_Function = MainFrame.getValueAt(MainFrame.this.jtbSearchRZ, rowi, "Exon_Intron_Function");
                            String Parent_CDS_in_circ = MainFrame.getValueAt(MainFrame.this.jtbSearchRZ, rowi, "Parent_CDS_in_circ");
                            if (Parent_CDS_in_circ.equals("") | Exon_Intron_Function.equals("")) {
                                MainFrame.this.annotateCircRNA(circRNA, chrStr, refGene, null, topLeftStr, seq);
                            } else {
                                if (Parent_CDS_in_circ.equals("None")) {
                                    Parent_CDS_in_circ = null;
                                }
                                MainFrame.this.showCircRNA(chrStr, refGene, null, topLeftStr, seq, Exon_Intron_Function, Parent_CDS_in_circ);
                            }
                            MainFrame.this.pgbSearch.setVisible(false);
                            MainFrame.this.jtbSearchRZ.getSelectionModel().clearSelection();
                        }
                    }.start();
                }
            }
        });
        this.jtbSearchRZ.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 3) {
                    MainFrame.this.popupMenuSearch.show(MainFrame.this.jtbSearchRZ, e.getX(), e.getY());
                }
            }
        });
        this.scrollPaneSearch.setViewportView(this.jtbSearchRZ);
        this.popupMenuSearch = new JPopupMenu();
        JMenuItem menuItemSearchTxt = new JMenuItem("Export as text");
        menuItemSearchTxt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String[] colNames = new String[]{"circRNA", "chr", "Symbol", "NM", "Length", "seq"};
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                String fname = "Search Results " + df.format(System.currentTimeMillis()).replace(":", "-");
                String filePath = String.valueOf(exepath) + "\\" + fname + ".txt";
                MainFrame.writeTXT(filePath, MainFrame.this.jtbSearchRZ, colNames, "\t");
            }
        });
        this.popupMenuSearch.add(menuItemSearchTxt);
        JMenuItem menuItemSearchCsv = new JMenuItem("Export as csv");
        menuItemSearchCsv.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String[] colNames = new String[]{"circRNA", "chr", "Symbol", "NM", "Length", "seq"};
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                String fname = "Search Results " + df.format(System.currentTimeMillis()).replace(":", "-");
                String filePath = String.valueOf(exepath) + "\\" + fname + ".csv";
                MainFrame.writeTXT(filePath, MainFrame.this.jtbSearchRZ, colNames, ",");
            }
        });
        this.popupMenuSearch.add(menuItemSearchCsv);
        JMenuItem menuItemSearchFasta = new JMenuItem("Export as Fasta Format");
        menuItemSearchFasta.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String[] colNames = new String[]{"circRNA", "seq"};
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                String fname = "Search Results Fasta " + df.format(System.currentTimeMillis()).replace(":", "-");
                String filePath = String.valueOf(exepath) + "\\" + fname + ".txt";
                MainFrame.writeFasta(filePath, MainFrame.this.jtbSearchRZ, colNames);
            }
        });
        this.popupMenuSearch.add(menuItemSearchFasta);
        this.scrollPaneSearch.add(this.popupMenuSearch);
        tabbedPane = new JTabbedPane(1);
        tabbedPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent arg0) {
                MainFrame.this.jtbSearchRZ.getSelectionModel().clearSelection();
                MainFrame.this.jtbPrimer.getSelectionModel().clearSelection();
                MainFrame.this.jtbAnnotate.getSelectionModel().clearSelection();
            }
        });
        tabbedPane.setBounds(343, 10, 390, 644);
        this.contentPane.add(tabbedPane);
        this.scrollPane_2 = new JScrollPane();
        tabbedPane.addTab("Check Primer", null, this.scrollPane_2, null);
        this.panel_1 = new JPanel();
        this.scrollPane_2.setViewportView(this.panel_1);
        this.panel_1.setLayout(null);
        Check = new JButton("Check");
        Check.setBounds(278, 12, 90, 25);
        this.panel_1.add(Check);
        this.txtF = new JTextField();
        this.txtF.setBounds(30, 14, 212, 21);
        this.panel_1.add(this.txtF);
        this.txtF.setColumns(10);
        this.txtF.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent event) {
                MainFrame.this.lblFL.setText(String.valueOf(MainFrame.this.txtF.getText().trim().length()));
            }

            @Override
            public void insertUpdate(DocumentEvent event) {
                MainFrame.this.lblFL.setText(String.valueOf(MainFrame.this.txtF.getText().trim().length()));
            }

            @Override
            public void removeUpdate(DocumentEvent event) {
                MainFrame.this.lblFL.setText(String.valueOf(MainFrame.this.txtF.getText().trim().length()));
            }
        });
        this.txtR = new JTextField();
        this.txtR.setBounds(30, 45, 212, 21);
        this.panel_1.add(this.txtR);
        this.txtR.setColumns(10);
        this.txtR.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent event) {
                MainFrame.this.lblRL.setText(String.valueOf(MainFrame.this.txtR.getText().trim().length()));
            }

            @Override
            public void insertUpdate(DocumentEvent event) {
                MainFrame.this.lblRL.setText(String.valueOf(MainFrame.this.txtR.getText().trim().length()));
            }

            @Override
            public void removeUpdate(DocumentEvent event) {
                MainFrame.this.lblRL.setText(String.valueOf(MainFrame.this.txtR.getText().trim().length()));
            }
        });
        this.lblF = new JLabel("F:");
        this.lblF.setBounds(10, 17, 27, 15);
        this.panel_1.add(this.lblF);
        this.lblR = new JLabel("R:");
        this.lblR.setBounds(10, 48, 27, 15);
        this.panel_1.add(this.lblR);
        this.lblFL = new JLabel("0");
        this.lblFL.setBounds(248, 17, 30, 15);
        this.panel_1.add(this.lblFL);
        this.lblRL = new JLabel("0");
        this.lblRL.setBounds(248, 48, 30, 15);
        this.panel_1.add(this.lblRL);
        this.lblPrimerColunt = new JLabel("Record Count: 0");
        this.lblPrimerColunt.setBounds(278, 48, 110, 15);
        this.panel_1.add(this.lblPrimerColunt);
        Check.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                final String F = MainFrame.this.txtF.getText();
                final String R = MainFrame.this.txtR.getText();
                if (F.trim().length() == 0 | R.trim().length() == 0) {
                    return;
                }
                new Thread(){

                    @Override
                    public void run() {
                        MainFrame.this.pgbPrimer.setVisible(true);
                        String org = "";
                        Items items = (Items)MainFrame.this.cbxOrganism.getSelectedItem();
                        org = items.getValue();
                        Check.setEnabled(false);
                        DefaultTableModel model = function.checkPrimer(org, F, R);
                        MainFrame.this.jtbPrimer.setModel(function.checkPrimer(org, F, R));
                        MainFrame.this.lblPrimerColunt.setText("Record Count: " + String.valueOf(model.getRowCount()));
                        TableColumnModel columnModel = MainFrame.this.jtbPrimer.getColumnModel();
                        TableColumn tableColumn = columnModel.getColumn(6);
                        tableColumn.setMaxWidth(0);
                        tableColumn.setMinWidth(0);
                        tableColumn.setPreferredWidth(0);
                        tableColumn = columnModel.getColumn(5);
                        tableColumn.setMaxWidth(0);
                        tableColumn.setMinWidth(0);
                        tableColumn.setPreferredWidth(0);
                        tableColumn = columnModel.getColumn(4);
                        tableColumn.setMaxWidth(0);
                        tableColumn.setMinWidth(0);
                        tableColumn.setPreferredWidth(0);
                        int i = 7;
                        while (i < columnModel.getColumnCount()) {
                            tableColumn = columnModel.getColumn(i);
                            tableColumn.setMaxWidth(0);
                            tableColumn.setMinWidth(0);
                            tableColumn.setPreferredWidth(0);
                            ++i;
                        }
                        TableColumn Column1 = MainFrame.this.jtbPrimer.getColumnModel().getColumn(0);
                        Column1.setPreferredWidth(110);
                        DefaultTableCellRenderer render = new DefaultTableCellRenderer();
                        render.setHorizontalAlignment(2);
                        Column1.setCellRenderer(render);
                        TableColumn Column2 = MainFrame.this.jtbPrimer.getColumnModel().getColumn(1);
                        Column2.setPreferredWidth(80);
                        TableColumn Column3 = MainFrame.this.jtbPrimer.getColumnModel().getColumn(1);
                        Column3.setPreferredWidth(80);
                        MainFrame.this.scrollPanePrimer.setViewportView(MainFrame.this.jtbPrimer);
                        Check.setEnabled(true);
                        MainFrame.makeFace(MainFrame.this.jtbPrimer, 7);
                        MainFrame.this.pgbPrimer.setVisible(false);
                    }
                }.start();
            }
        });
        this.scrollPane_1 = new JScrollPane();
        tabbedPane.addTab("Search Results", null, this.scrollPane_1, null);
        this.panel_2 = new JPanel();
        this.scrollPane_1.setViewportView(this.panel_2);
        this.panel_2.setLayout(null);
        this.cbxAnnotate = new JCheckBox("Annotate circRNA when click");
        this.cbxAnnotate.setSelected(true);
        this.cbxAnnotate.setBounds(10, 16, 208, 23);
        this.panel_2.add(this.cbxAnnotate);
        this.lblSearchCount = new JLabel("0");
        this.lblSearchCount.setBounds(307, 20, 54, 15);
        this.panel_2.add(this.lblSearchCount);
        this.label = new JLabel("Record Count:");
        this.label.setBounds(224, 20, 83, 15);
        this.panel_2.add(this.label);
        this.panel_2.add(this.scrollPaneSearch);
        this.pgbSearch = new JProgressBar();
        this.pgbSearch.setVisible(false);
        this.pgbSearch.setBounds(10, 45, 361, 14);
        this.pgbSearch.setIndeterminate(true);
        this.panel_2.add(this.pgbSearch);
        this.scrollPane_3 = new JScrollPane();
        tabbedPane.addTab("Annotated Results", null, this.scrollPane_3, null);
        this.panel_3 = new JPanel();
        this.scrollPane_3.setViewportView(this.panel_3);
        this.panel_3.setLayout(null);
        final JLabel lbl_annotated_count = new JLabel("0");
        lbl_annotated_count.setBounds(105, 22, 50, 15);
        this.panel_3.add(lbl_annotated_count);
        JLabel lblRowCount = new JLabel("Record Count:");
        lblRowCount.setBounds(22, 22, 83, 15);
        this.panel_3.add(lblRowCount);
        this.rdbtnShowRna = new JRadioButton("Show RNA");
        this.rdbtnShowRna.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (MainFrame.this.rdbtnShowRna.isSelected()) {
                    MainFrame.this.rdbtnShowDna.setSelected(false);
                } else {
                    MainFrame.this.rdbtnShowDna.setSelected(true);
                }
            }
        });
        this.rdbtnShowRna.setSelected(true);
        this.rdbtnShowRna.setBounds(162, 18, 88, 23);
        this.panel_3.add(this.rdbtnShowRna);
        this.panel_3.add(this.scrollPaneAnnotate);
        this.rdbtnShowDna = new JRadioButton("Show DNA");
        this.rdbtnShowDna.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent arg0) {
                int rowi = MainFrame.this.jtbAnnotate.getSelectedRow();
                if (rowi == -1) {
                    return;
                }
                String DNA_SEQ = MainFrame.getValueAt(MainFrame.this.jtbAnnotate, rowi, "DNA_SEQ");
                String RNA_SEQ = MainFrame.getValueAt(MainFrame.this.jtbAnnotate, rowi, "RNA_SEQ");
                if (MainFrame.this.rdbtnShowRna.isSelected()) {
                    MainFrame.this.txtAseq.setText(RNA_SEQ);
                }
                if (MainFrame.this.rdbtnShowDna.isSelected()) {
                    MainFrame.this.txtAseq.setText(DNA_SEQ);
                }
            }
        });
        this.rdbtnShowDna.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (MainFrame.this.rdbtnShowDna.isSelected()) {
                    MainFrame.this.rdbtnShowRna.setSelected(false);
                } else {
                    MainFrame.this.rdbtnShowRna.setSelected(true);
                }
            }
        });
        this.rdbtnShowDna.setBounds(252, 18, 88, 23);
        this.panel_3.add(this.rdbtnShowDna);
        this.pgbAnnotated = new JProgressBar();
        this.pgbAnnotated.setVisible(false);
        this.pgbAnnotated.setBounds(10, 46, 361, 14);
        this.pgbAnnotated.setIndeterminate(true);
        this.panel_3.add(this.pgbAnnotated);
        this.scrollPanePrimer = new JScrollPane();
        this.scrollPanePrimer.setBounds(10, 80, 361, 195);
        this.panel_1.add(this.scrollPanePrimer);
        DefaultTableModel model = new DefaultTableModel();
        model.addColumn("circRNA");
        model.addColumn("Symbol");
        model.addColumn("Length");
        model.addColumn("F0R");
        this.jtbPrimer = new JTable(model);
        TableColumn Column11 = this.jtbPrimer.getColumnModel().getColumn(0);
        Column11.setPreferredWidth(110);
        TableColumn Column22 = this.jtbPrimer.getColumnModel().getColumn(1);
        Column22.setPreferredWidth(80);
        this.jtbPrimer.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    new Thread(){

                        @Override
                        public void run() {
                            MainFrame.this.pgbPrimer.setVisible(true);
                            if (cbxGTF.getSelectedIndex() == -1) {
                                MainFrame.this.pgbPrimer.setVisible(false);
                                JOptionPane.showMessageDialog(null, "Please select refGene!", "Message", -1);
                                cbxGTF.requestFocus();
                                cbxGTF.showPopup();
                                return;
                            }
                            int rowi = MainFrame.this.jtbPrimer.getSelectedRow();
                            if (rowi == -1) {
                                MainFrame.this.pgbPrimer.setVisible(false);
                                return;
                            }
                            String circRNA = MainFrame.getValueAt(MainFrame.this.jtbPrimer, rowi, "circRNA");
                            String Homeotic_Gene = MainFrame.getValueAt(MainFrame.this.jtbPrimer, rowi, "Homeotic_Gene");
                            String seq = MainFrame.getValueAt(MainFrame.this.jtbPrimer, rowi, "seq");
                            if (Homeotic_Gene.length() > 0) {
                                String Homeotic_Gene_Seq = function.getCircRNASeq(Homeotic_Gene);
                                String s = function.clustalw2(circRNA, seq, Homeotic_Gene, Homeotic_Gene_Seq);
                                txtAseq2.setText(s);
                            } else {
                                txtAseq2.setText("");
                            }
                            String chrStr = MainFrame.getValueAt(MainFrame.this.jtbPrimer, rowi, "chr");
                            String circPrimerInf = MainFrame.getValueAt(MainFrame.this.jtbPrimer, rowi, "primerInf");
                            String org = circRNA.substring(0, 3);
                            String refGene = "";
                            if (org.equals("hsa")) {
                                MainFrame.this.setCbxItem(MainFrame.this.cbxOrganism, "Homo Sapiens");
                            }
                            if (org.equals("mmu")) {
                                MainFrame.this.setCbxItem(MainFrame.this.cbxOrganism, "Mus Musculus");
                            }
                            cbxGTF.setSelectedIndex(0);
                            Item item = (Item)cbxGTF.getSelectedItem();
                            refGene = item.getrefGene();
                            String topLeftStr = String.valueOf(circRNA) + " " + MainFrame.getValueAt(MainFrame.this.jtbPrimer, rowi, "Symbol") + "\n";
                            topLeftStr = String.valueOf(topLeftStr) + MainFrame.getValueAt(MainFrame.this.jtbPrimer, rowi, "chr") + "\n";
                            topLeftStr = String.valueOf(topLeftStr) + MainFrame.getValueAt(MainFrame.this.jtbPrimer, rowi, "NM") + "\n";
                            topLeftStr = String.valueOf(topLeftStr) + String.valueOf(MainFrame.getValueAt(MainFrame.this.jtbPrimer, rowi, "seq").length());
                            String Exon_Intron_Function = MainFrame.getValueAt(MainFrame.this.jtbPrimer, rowi, "Exon_Intron_Function");
                            String Parent_CDS_in_circ = MainFrame.getValueAt(MainFrame.this.jtbPrimer, rowi, "Parent_CDS_in_circ");
                            if (Parent_CDS_in_circ.equals("") | Exon_Intron_Function.equals("")) {
                                MainFrame.this.annotateCircRNA(circRNA, chrStr, refGene, circPrimerInf, topLeftStr, seq);
                            } else {
                                if (Parent_CDS_in_circ.equals("None")) {
                                    Parent_CDS_in_circ = null;
                                }
                                MainFrame.this.showCircRNA(chrStr, refGene, circPrimerInf, topLeftStr, seq, Exon_Intron_Function, Parent_CDS_in_circ);
                            }
                            MainFrame.this.pgbPrimer.setVisible(false);
                            MainFrame.this.jtbPrimer.getSelectionModel().clearSelection();
                        }
                    }.start();
                }
            }
        });
        this.jtbPrimer.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 3) {
                    MainFrame.this.popupMenuPimer.show(MainFrame.this.jtbPrimer, e.getX(), e.getY());
                }
            }
        });
        this.scrollPanePrimer.setViewportView(this.jtbPrimer);
        this.popupMenuPimer = new JPopupMenu();
        JMenuItem menuItemPrimerTxt = new JMenuItem("Export as text");
        menuItemPrimerTxt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String[] colNames = new String[]{"circRNA", "chr", "Symbol", "NM", "Length", "F0R"};
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                String fname = "Primer " + df.format(System.currentTimeMillis()).replace(":", "-");
                String filePath = String.valueOf(exepath) + "\\" + fname + ".txt";
                MainFrame.writeTXT(filePath, MainFrame.this.jtbPrimer, colNames, "\t");
            }
        });
        this.popupMenuPimer.add(menuItemPrimerTxt);
        JMenuItem menuItemPrimerCsv = new JMenuItem("Export as csv");
        menuItemPrimerCsv.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String[] colNames = new String[]{"circRNA", "chr", "Symbol", "NM", "Length", "F0R"};
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                String fname = "Primer " + df.format(System.currentTimeMillis()).replace(":", "-");
                String filePath = String.valueOf(exepath) + "\\" + fname + ".csv";
                MainFrame.writeTXT(filePath, MainFrame.this.jtbPrimer, colNames, ",");
            }
        });
        this.popupMenuPimer.add(menuItemPrimerCsv);
        this.scrollPanePrimer.add(this.popupMenuPimer);
        this.pgbPrimer = new JProgressBar();
        this.pgbPrimer.setBounds(10, 67, 361, 14);
        this.pgbPrimer.setVisible(false);
        this.pgbPrimer.setIndeterminate(true);
        this.panel_1.add(this.pgbPrimer);
        this.panel = new JPanel();
        this.panel.setBounds(10, 10, 323, 644);
        this.panel.setBorder(new BevelBorder(1, null, null, null, null));
        this.contentPane.add(this.panel);
        this.panel.setLayout(null);
        this.lblSpecies = new JLabel("Organism:");
        this.lblSpecies.setBounds(10, 24, 69, 15);
        this.panel.add(this.lblSpecies);
        this.cbxOrganism = new JComboBox();
        this.init_cbxOrganism();
        this.cbxOrganism.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent arg0) {
                String Organism = MainFrame.this.cbxOrganism.getSelectedItem().toString();
                MainFrame.this.init_cbxGTF(Organism);
            }
        });
        this.cbxOrganism.setBounds(84, 21, 222, 21);
        this.panel.add(this.cbxOrganism);
        cbxGTF = new JComboBox();
        String Organism = this.cbxOrganism.getSelectedItem().toString();
        this.init_cbxGTF(Organism);
        cbxGTF.setBounds(84, 55, 222, 23);
        this.panel.add(cbxGTF);
        this.rbtMultipleCircrnas = new JRadioButton("Multiple circRNAs");
        this.rbtMultipleCircrnas.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                MainFrame.this.resize_panel_left();
            }
        });
        this.rbtMultipleCircrnas.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (MainFrame.this.rbtMultipleCircrnas.isSelected()) {
                    MainFrame.this.rbtSingle.setSelected(false);
                } else {
                    MainFrame.this.rbtSingle.setSelected(true);
                }
            }
        });
        this.rbtMultipleCircrnas.setBounds(162, 85, 144, 23);
        this.panel.add(this.rbtMultipleCircrnas);
        this.rbtSingle = new JRadioButton("Single circRNA");
        this.rbtSingle.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent arg0) {
                if (MainFrame.this.rbtSingle.isSelected()) {
                    MainFrame.this.rbtMultipleCircrnas.setSelected(false);
                } else {
                    MainFrame.this.rbtMultipleCircrnas.setSelected(true);
                }
            }
        });
        this.rbtSingle.setSelected(true);
        this.rbtSingle.setBounds(10, 85, 121, 23);
        this.panel.add(this.rbtSingle);
        this.txtCircRNA = new JTextField();
        this.txtCircRNA.setBounds(10, 120, 296, 21);
        this.panel.add(this.txtCircRNA);
        this.txtCircRNA.setColumns(10);
        btnCircbase = new JButton("Search");
        btnCircbase.setBounds(110, 300, 90, 25);
        btnCircbase.setToolTipText("Search circBase");
        this.panel.add(btnCircbase);
        this.scpTxtArea = new JScrollPane();
        this.scpTxtArea.setBounds(10, 120, 296, 260);
        this.panel.add(this.scpTxtArea);
        this.scpTxtArea.setVisible(false);
        this.txtAcircRNAs = new JTextArea();
        this.txtAcircRNAs.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent event) {
                String[] line = MainFrame.this.txtAcircRNAs.getText().split("\n");
                MainFrame.this.lblInputLineCount.setText(String.valueOf(line.length));
            }

            @Override
            public void insertUpdate(DocumentEvent event) {
                String[] line = MainFrame.this.txtAcircRNAs.getText().split("\n");
                MainFrame.this.lblInputLineCount.setText(String.valueOf(line.length));
            }

            @Override
            public void removeUpdate(DocumentEvent event) {
                String[] line = MainFrame.this.txtAcircRNAs.getText().split("\n");
                MainFrame.this.lblInputLineCount.setText(String.valueOf(line.length));
            }
        });
        this.scpTxtArea.setViewportView(this.txtAcircRNAs);
        btnAnnotate = new JButton("Annotate");
        btnAnnotate.setBounds(10, 400, 90, 25);
        this.panel.add(btnAnnotate);
        JLabel lblRefgene = new JLabel("RefGene:");
        lblRefgene.setBounds(10, 59, 69, 15);
        this.panel.add(lblRefgene);
        this.lblInputLineCount = new JLabel("0");
        this.lblInputLineCount.setBounds(255, 405, 54, 15);
        this.panel.add(this.lblInputLineCount);
        progressBar = new JProgressBar();
        progressBar.setBounds(10, 620, 296, 14);
        this.panel.add(progressBar);
        this.lblNewLabel = new JLabel("Row Count:");
        this.lblNewLabel.setBounds(188, 405, 69, 15);
        this.panel.add(this.lblNewLabel);
        this.panel_help = new JPanel();
        this.panel_help.setBounds(10, 495, 296, 115);
        this.panel.add(this.panel_help);
        this.panel_help.setLayout(null);
        this.lblhelp = new JLabel("<html><u>Help</u><html>");
        this.lblhelp.setBounds(0, 54, 28, 15);
        this.panel_help.add(this.lblhelp);
        this.lblhelp.setForeground(new Color(0, 0, 255));
        this.lblDesinged = new JLabel("Designed by Shanliang Zhong");
        this.lblDesinged.setBounds(0, 74, 197, 21);
        this.panel_help.add(this.lblDesinged);
        this.lblDesinged.setForeground(new Color(0, 0, 255));
        JLabel lblEmailSlzhongnjmueducn = new JLabel("Email: slzhong@njmu.edu.cn");
        lblEmailSlzhongnjmueducn.setForeground(Color.BLUE);
        lblEmailSlzhongnjmueducn.setBounds(0, 94, 197, 21);
        this.panel_help.add(lblEmailSlzhongnjmueducn);
        lblDownloadNewVer = new JLabel("<html><u>A new version is available!</u><html>");
        lblDownloadNewVer.setForeground(Color.RED);
        lblDownloadNewVer.setVisible(false);
        lblDownloadNewVer.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent arg0) {
                Desktop desktop = Desktop.getDesktop();
                URI uri = null;
                try {
                    uri = new URI(NEW_VER_URL);
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                }
                try {
                    desktop.browse(uri);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
        lblDownloadNewVer.setBounds(0, 34, 182, 15);
        this.panel_help.add(lblDownloadNewVer);
        this.txtpnWew = new JTextPane();
        this.txtpnWew.setEditable(false);
        this.txtpnWew.setText("wew");
        this.txtpnWew.setBackground(UIManager.getColor("Button.background"));
        this.txtpnWew.setBounds(10, 435, 296, 76);
        this.panel.add(this.txtpnWew);
        lblversion2 = new JLabel("6");
        lblversion2.setBounds(10, -1, 54, 15);
        lblversion2.setVisible(false);
        this.panel.add(lblversion2);
        this.lblhelp.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent arg0) {
                Desktop desktop = Desktop.getDesktop();
                URI uri = null;
                try {
                    uri = new URI("http://www.bio-inf.cn");
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                }
                try {
                    desktop.browse(uri);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
        panel_right = new JPanel();
        panel_right.setBorder(new BevelBorder(1, null, null, null, null));
        panel_right.setBounds(743, 10, 482, 644);
        this.contentPane.add(panel_right);
        panel_right.setLayout(null);
        this.scrollPaneSeq1 = new JScrollPane();
        this.scrollPaneSeq1.setBounds(10, 33, 462, 221);
        panel_right.add(this.scrollPaneSeq1);
        this.txtAseq = new JTextArea();
        this.txtAseq.setLineWrap(true);
        this.scrollPaneSeq1.setViewportView(this.txtAseq);
        final JPopupMenu popupMenutxtAseq = new JPopupMenu();
        JMenuItem menuItemProtein = new JMenuItem("Predict ORF and IRES with this Sequence");
        menuItemProtein.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MainFrame.this.txtAseq.getText().trim().length() == 0) {
                    return;
                }
                MainFrame.this.fm.setVisible(false);
                MainFrame.this.fm.setFirstPaint(true);
                MainFrame.this.fm.setCircLen(MainFrame.this.txtAseq.getText().trim().length());
                MainFrame.this.fm.setCbxMindex(2);
                MainFrame.this.fm.setTopLeftInf(null);
                MainFrame.this.fm.setBottomLeftInf(null);
                MainFrame.this.fm.setCircStructure(null);
                MainFrame.this.fm.setParent_CDS_in_circ(null);
                MainFrame.this.fm.setCircFuntion(null);
                MainFrame.this.fm.setCirc_m6a_str(null);
                MainFrame.this.fm.setCircSymbol(null);
                MainFrame.this.fm.setSeq(MainFrame.this.txtAseq.getText().trim().toUpperCase());
                MainFrame.this.fm.setCircPrimerInf(null);
                MainFrame.this.fm.setDefaultCloseOperation(2);
                ((MainFrame)MainFrame.this).fm.panelLeft.repaint();
                MainFrame.this.fm.setVisible(true);
            }
        });
        popupMenutxtAseq.add(menuItemProtein);
        this.txtAseq.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 3) {
                    popupMenutxtAseq.show(MainFrame.this.txtAseq, e.getX(), e.getY());
                }
            }
        });
        this.txtAseq.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent event) {
                MainFrame.this.lblLength.setText(String.valueOf("Length: " + MainFrame.this.txtAseq.getText().length()));
            }

            @Override
            public void insertUpdate(DocumentEvent event) {
                MainFrame.this.lblLength.setText(String.valueOf("Length: " + MainFrame.this.txtAseq.getText().length()));
            }

            @Override
            public void removeUpdate(DocumentEvent event) {
                MainFrame.this.lblLength.setText(String.valueOf("Length: " + MainFrame.this.txtAseq.getText().length()));
            }
        });
        this.scrollPaneSeq2 = new JScrollPane();
        this.scrollPaneSeq2.setBounds(10, 291, 462, 319);
        panel_right.add(this.scrollPaneSeq2);
        txtAseq2 = new JTextArea();
        txtAseq2.setLineWrap(true);
        txtAseq2.setFont(new Font("monospaced", 0, 14));
        this.scrollPaneSeq2.setViewportView(txtAseq2);
        this.lblCircrnaSequence = new JLabel("circRNA Sequence");
        this.lblCircrnaSequence.setBounds(10, 10, 114, 15);
        panel_right.add(this.lblCircrnaSequence);
        this.lblLength = new JLabel("Length: 0");
        this.lblLength.setBounds(200, 10, 124, 15);
        panel_right.add(this.lblLength);
        this.panel_4 = new JPanel();
        this.panel_4.setBounds(134, 10, 299, 30);
        panel_right.add(this.panel_4);
        this.panel_4.setLayout(null);
        JButton btnNewButton_1 = new JButton("Complement");
        btnNewButton_1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent arg0) {
                txtAseq2.setText(function.complement(MainFrame.this.txtAseq.getText()));
            }
        });
        btnNewButton_1.setBounds(0, 5, 93, 23);
        this.panel_4.add(btnNewButton_1);
        btnNewButton_1.setMargin(new Insets(0, 0, 0, 0));
        JButton btnReverse = new JButton("Reverse");
        btnReverse.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                txtAseq2.setText(function.reverse(MainFrame.this.txtAseq.getText()));
            }
        });
        btnReverse.setBounds(103, 5, 93, 23);
        this.panel_4.add(btnReverse);
        btnReverse.setMargin(new Insets(0, 0, 0, 0));
        JButton btnRevComp = new JButton("Rev. Comp.");
        btnRevComp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                txtAseq2.setText(function.reverse_complement(MainFrame.this.txtAseq.getText()));
            }
        });
        btnRevComp.setBounds(206, 5, 93, 23);
        this.panel_4.add(btnRevComp);
        btnRevComp.setMargin(new Insets(0, 0, 0, 0));
        this.panel_5 = new JPanel();
        this.panel_5.setBounds(10, 255, 465, 30);
        panel_right.add(this.panel_5);
        this.panel_5.setLayout(null);
        this.rbtPrimer1 = new JRadioButton("Divergent primer");
        this.rbtPrimer1.setSelected(true);
        this.rbtPrimer1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (MainFrame.this.rbtPrimer1.isSelected()) {
                    MainFrame.this.rbtPrimer2.setSelected(false);
                } else {
                    MainFrame.this.rbtPrimer2.setSelected(true);
                }
            }
        });
        this.rbtPrimer1.setBounds(0, 6, 124, 23);
        this.panel_5.add(this.rbtPrimer1);
        this.rbtPrimer2 = new JRadioButton("One primer spanning junction");
        this.rbtPrimer2.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (MainFrame.this.rbtPrimer2.isSelected()) {
                    MainFrame.this.rbtPrimer1.setSelected(false);
                } else {
                    MainFrame.this.rbtPrimer1.setSelected(true);
                }
            }
        });
        this.rbtPrimer2.setBounds(120, 6, 193, 23);
        this.panel_5.add(this.rbtPrimer2);
        this.btnTemplate = new JButton("Template");
        this.btnTemplate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String buf = function.FormatSeq(MainFrame.this.txtAseq.getText());
                int l = buf.length();
                if (l < 30) {
                    txtAseq2.setText("The circRNA sequence is too short to disign primer!\n");
                    return;
                }
                int headL = l / 2;
                int tailL = l - headL;
                String head = buf.substring(0, headL);
                String tail = buf.substring(headL, l);
                if (MainFrame.this.rbtPrimer1.isSelected()) {
                    String b = String.valueOf(tail.substring(0, tailL - 1)) + "[" + tail.substring(tailL - 1, tailL) + head.substring(0, 1) + "]" + head.substring(1, headL);
                    txtAseq2.setText("Click the link of 'Primer3' and paste the template into Primer3\uff0cthen click 'Pick Primers' in Primer3\n\n" + b);
                    Clipboard clip = Toolkit.getDefaultToolkit().getSystemClipboard();
                    StringSelection tText = new StringSelection(b);
                    clip.setContents(tText, null);
                } else {
                    String b = String.valueOf(tail) + "-" + head;
                    txtAseq2.setText("Click the link of 'Primer3' and paste the template into Primer3\uff0cthen click 'Pick Primers' in Primer3\n\n" + b);
                    Clipboard clip = Toolkit.getDefaultToolkit().getSystemClipboard();
                    StringSelection tText = new StringSelection(b);
                    clip.setContents(tText, null);
                }
            }
        });
        this.btnTemplate.setBounds(369, 5, 93, 23);
        this.panel_5.add(this.btnTemplate);
        this.lblNewLabel_1 = new JLabel("<html><u>Primer3</u><html>");
        this.lblNewLabel_1.setForeground(new Color(0, 0, 255));
        this.lblNewLabel_1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent arg0) {
                Desktop desktop = Desktop.getDesktop();
                URI uri = null;
                try {
                    uri = new URI("https://primer3.ut.ee/");
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                }
                try {
                    desktop.browse(uri);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
        this.lblNewLabel_1.setBounds(316, 7, 54, 15);
        this.panel_5.add(this.lblNewLabel_1);
        JButton btnNewButton = new JButton("New button");
        btnNewButton.setVisible(false);
        btnNewButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                new Thread(){

                    @Override
                    public void run() {
                        function.update_all_Parent_CDS_in_circ();
                    }
                }.start();
            }
        });
        btnNewButton.setBounds(403, 0, 93, 23);
        panel_right.add(btnNewButton);
        btnAnnotate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (cbxGTF.getSelectedIndex() == -1) {
                    JOptionPane.showMessageDialog(null, "Please select refGene!", "Message", -1);
                    cbxGTF.requestFocus();
                    cbxGTF.showPopup();
                    return;
                }
                lbl_annotated_count.setText("0");
                final Item item = (Item)cbxGTF.getSelectedItem();
                final DefaultTableModel model1 = new DefaultTableModel();
                model1.addColumn("circRNA");
                model1.addColumn("chr");
                model1.addColumn("Symbol");
                model1.addColumn("DNA_SEQ");
                model1.addColumn("RNA_SEQ");
                model1.addColumn("Function_Str");
                model1.addColumn("circStructure");
                model1.addColumn("strand");
                model1.addColumn("NM");
                model1.addColumn("SymbolcircBase");
                model1.addColumn("Length");
                model1.addColumn("Seq");
                model1.addColumn("bottomLeftInf");
                model1.addColumn("Homeotic_Gene");
                model1.addColumn("m6a");
                model1.addColumn("Parent_CDS_in_circ");
                if (MainFrame.this.rbtSingle.isSelected()) {
                    final String txtinput = MainFrame.this.txtCircRNA.getText().trim();
                    if (txtinput.length() == 0) {
                        return;
                    }
                    if (txtinput.indexOf("chr") == -1 & txtinput.indexOf("_circ_") == -1) {
                        return;
                    }
                    new Thread(){

                        @Override
                        public void run() {
                            String[] rz;
                            btnAnnotate.setEnabled(false);
                            MainFrame.this.pgbAnnotated.setVisible(true);
                            String[] result = function.getCircRNAFromInput(txtinput, item.getrefGene());
                            if (result == null) {
                                result = new String[]{function.FormatChr(txtinput), "", "", "", "", "", ""};
                            }
                            if ((rz = MainFrame.this.annotateCircRNA(item, result[0])) == null) {
                                JOptionPane.showMessageDialog(null, "No parental gene was found for '" + txtinput + "'", "Message", -1);
                                btnAnnotate.setEnabled(true);
                                MainFrame.this.pgbAnnotated.setVisible(false);
                                return;
                            }
                            model1.addRow(new Object[]{result[1], result[0], rz[0], rz[4], rz[5], rz[3], rz[2], rz[1], result[2], result[3], result[4], result[5], rz[6], result[6], rz[7], rz[8]});
                            btnAnnotate.setEnabled(true);
                            MainFrame.this.pgbAnnotated.setVisible(false);
                            lbl_annotated_count.setText("1");
                        }
                    }.start();
                } else {
                    new Thread(){

                        @Override
                        public void run() {
                            btnAnnotate.setEnabled(false);
                            MainFrame.this.pgbAnnotated.setVisible(true);
                            try {
                                String[] line = MainFrame.this.txtAcircRNAs.getText().split("\n");
                                progressBar.setVisible(true);
                                progressBar.setMinimum(0);
                                progressBar.setMaximum(line.length);
                                String inf = "";
                                int failedCount = 0;
                                progressBar.setValue(0);
                                int i = 0;
                                while (i < line.length) {
                                    String circRNA = line[i].trim();
                                    if (circRNA.length() != 0) {
                                        if (circRNA.indexOf("chr") == -1 & circRNA.indexOf("_circ_") == -1) {
                                            inf = String.valueOf(inf) + "Unable to annotate '" + line[i].trim() + "'\n";
                                            ++failedCount;
                                        } else {
                                            String[] result = function.getCircRNAFromInput(circRNA, item.getrefGene());
                                            if (result == null) {
                                                result = new String[]{function.FormatChr(circRNA), "", "", "", "", "", ""};
                                            }
                                            inf = String.valueOf(inf) + "Annotating " + circRNA + "\n";
                                            txtAseq2.setText(inf);
                                            String[] rz = MainFrame.this.annotateCircRNA(item, result[0]);
                                            if (rz == null) {
                                                inf = String.valueOf(inf) + "No parental gene was found for '" + line[i].trim() + "'\n";
                                                ++failedCount;
                                            } else {
                                                model1.addRow(new Object[]{result[1], result[0], rz[0], rz[4], rz[5], rz[3], rz[2], rz[1], result[2], result[3], result[4], result[5], rz[6], result[6], rz[7], rz[8]});
                                                lbl_annotated_count.setText(String.valueOf(model1.getRowCount()));
                                            }
                                            progressBar.setValue(i + 1);
                                        }
                                    }
                                    ++i;
                                }
                                progressBar.setVisible(false);
                                inf = String.valueOf(inf) + "Done." + "\n";
                                inf = String.valueOf(inf) + "Successed: " + lbl_annotated_count.getText() + "   Failed:" + String.valueOf(failedCount) + "\n";
                                txtAseq2.setText(inf);
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                            btnAnnotate.setEnabled(true);
                            MainFrame.this.pgbAnnotated.setVisible(false);
                        }
                    }.start();
                }
                MainFrame.this.jtbAnnotate.setModel(model1);
                TableColumnModel columnModel = MainFrame.this.jtbAnnotate.getColumnModel();
                TableColumn C1 = null;
                int i = 3;
                while (i < 16) {
                    TableColumn tableColumn = columnModel.getColumn(i);
                    tableColumn.setMaxWidth(0);
                    tableColumn.setMinWidth(0);
                    tableColumn.setPreferredWidth(0);
                    ++i;
                }
                if (item.gethg().equals("hg19") | item.gethg().equals("mm9")) {
                    C1 = MainFrame.this.jtbAnnotate.getColumnModel().getColumn(0);
                    C1.setPreferredWidth(110);
                    C1 = MainFrame.this.jtbAnnotate.getColumnModel().getColumn(1);
                    C1.setPreferredWidth(170);
                } else {
                    C1 = MainFrame.this.jtbAnnotate.getColumnModel().getColumn(0);
                    C1.setPreferredWidth(170);
                    TableColumn tableColumn = columnModel.getColumn(0);
                    tableColumn.setMaxWidth(0);
                    tableColumn.setMinWidth(0);
                    tableColumn.setPreferredWidth(0);
                }
                MainFrame.this.scrollPaneAnnotate.setViewportView(MainFrame.this.jtbAnnotate);
                lbl_annotated_count.setText(String.valueOf(model1.getRowCount()));
                tabbedPane.setSelectedIndex(2);
                MainFrame.makeFace(MainFrame.this.jtbAnnotate, 13);
            }
        });
        btnCircbase.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Thread thread = new Thread(){

                    @Override
                    public void run() {
                        Runnable runnable = new Runnable(){

                            @Override
                            public void run() {
                                MainFrame.this.pgbSearch.setVisible(true);
                                btnCircbase.setEnabled(false);
                                String s = MainFrame.this.txtCircRNA.getText().trim();
                                DefaultTableModel model = new DefaultTableModel();
                                model = s.replace("-", "_").indexOf("_circ_") != -1 ? function.searchCircRNA(s.replace("-", "_"), "circbaseID") : (s.indexOf("chr") == 0 ? function.searchCircRNA(s, "chr") : function.searchCircRNA(s, "symbol"));
                                if (model == null) {
                                    return;
                                }
                                MainFrame.this.jtbSearchRZ.setModel(model);
                                TableColumnModel columnModel = MainFrame.this.jtbSearchRZ.getColumnModel();
                                TableColumn tableColumn = columnModel.getColumn(2);
                                tableColumn.setMaxWidth(0);
                                tableColumn.setMinWidth(0);
                                tableColumn.setPreferredWidth(0);
                                int i = 4;
                                while (i < columnModel.getColumnCount()) {
                                    tableColumn = columnModel.getColumn(i);
                                    tableColumn.setMaxWidth(0);
                                    tableColumn.setMinWidth(0);
                                    tableColumn.setPreferredWidth(0);
                                    ++i;
                                }
                                TableColumn Column1 = MainFrame.this.jtbSearchRZ.getColumnModel().getColumn(0);
                                Column1.setPreferredWidth(116);
                                TableColumn Column2 = MainFrame.this.jtbSearchRZ.getColumnModel().getColumn(1);
                                Column2.setPreferredWidth(170);
                                MainFrame.this.scrollPaneSearch.setViewportView(MainFrame.this.jtbSearchRZ);
                                MainFrame.this.lblSearchCount.setText(String.valueOf(model.getRowCount()));
                                tabbedPane.setSelectedIndex(1);
                                btnCircbase.setEnabled(true);
                                MainFrame.makeFace(MainFrame.this.jtbSearchRZ, 7);
                                MainFrame.this.pgbSearch.setVisible(false);
                            }
                        };
                        SwingUtilities.invokeLater(runnable);
                    }
                };
                thread.start();
            }
        });
    }

    private static void addPopup(Component component, final JPopupMenu popup) {
        component.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.showMenu(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.showMenu(e);
                }
            }

            private void showMenu(MouseEvent e) {
                popup.show(e.getComponent(), e.getX(), e.getY());
            }
        });
    }

    public class Item {
        private String hg;
        private String refGene;
        private String GTF;

        public Item(String GTF, String hg, String refGene) {
            this.refGene = refGene;
            this.GTF = GTF;
            this.hg = hg;
        }

        public void sethg(String hg) {
            this.hg = hg;
        }

        public String gethg() {
            return this.hg;
        }

        public void setGTF(String GTF) {
            this.GTF = GTF;
        }

        public String getGTF() {
            return this.GTF;
        }

        public void setrefGene(String refGene) {
            this.refGene = refGene;
        }

        public String getrefGene() {
            return this.refGene;
        }

        public String toString() {
            return this.GTF;
        }
    }

    public class Items {
        private String item;
        private String value;

        public Items(String item, String value) {
            this.item = item;
            this.value = value;
        }

        public void setKey(String item) {
            this.item = item;
        }

        public String getItem() {
            return this.item;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return this.item;
        }
    }
}

